package com.biz.crm.tpm.business.activity.apply.rules.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2022/11/8 16:21
 * @description: 活动申请规则-促销规划金额计算Vo
 */
@Data
@ApiModel(value = "ActivityApplyRulesPromotionPlanAmountVo", description = "活动申请规则-促销规划金额计算Vo")
public class ActivityApplyRulesPromotionPlanAmountVo {

    /**
     * 产品促销（元）
     */
    @ApiModelProperty("产品促销（元）")
    private BigDecimal productPromotion;

    /**
     * 大日期处理（元）
     */
    @ApiModelProperty("大日期处理（元）")
    private BigDecimal largeDateProcess;

    /**
     * 新客专享（元）
     */
    @ApiModelProperty("新客专享（元）")
    private BigDecimal newCustomer;

    /**
     * 老客留存（元）
     */
    @ApiModelProperty("老客留存（元）")
    private BigDecimal oldCustomer;

    /**
     * 达人佣金（抖音）（元）
     */
    @ApiModelProperty("达人佣金（抖音）（元）")
    private BigDecimal tiktokMaster;

    /**
     * 平台毛保（元）
     */
    @ApiModelProperty("平台毛保（元）")
    private BigDecimal platformGrossProtection;

    /**
     * 平台服务费（元）
     */
    @ApiModelProperty("平台服务费（元）")
    private BigDecimal platformService;

    /**
     * 平台返点费用（元）
     */
    @ApiModelProperty("平台返点费用（元）")
    private BigDecimal platformRebate;

    /**
     * 平台佣金扣点（元）
     */
    @ApiModelProperty("平台佣金扣点（元）")
    private BigDecimal platformCommission;

    /**
     * 销售返点（元）
     */
    @ApiModelProperty("销售返点（元）")
    private BigDecimal saleCommission;

    /**
     * 物流费用（元）
     */
    @ApiModelProperty("物流费用（元）")
    private BigDecimal logistics;


    /**
     * 渠道推广费（元）
     */
    @ApiModelProperty("渠道推广费（元）")
    private BigDecimal channelPromotionFee;

    /**
     * 采购返点（元）
     */
    @ApiModelProperty("采购返点（元）")
    private BigDecimal purchaseRebate;


    /**
     * 费用池-补差
     */
    @ApiModelProperty("费用池-补差")
    private BigDecimal feePoolDifference;

    /**
     * 费用池-销售返
     */
    @ApiModelProperty("费用池-销售返")
    private BigDecimal feePoolSaleCommission;

    /**
     * 费用池-采购返
     */
    @ApiModelProperty("费用池-采购返")
    private BigDecimal feePoolPurchaseRebate;

    /**
     * 费用池-投放
     */
    @ApiModelProperty("费用池-投放")
    private BigDecimal feePoolPut;

    /**
     * 费用池-毛保
     */
    @ApiModelProperty("费用池-毛保")
    private BigDecimal feePoolGrossProtection;

    /**
     * 仓间不均（元）
     */
    @ApiModelProperty("仓间不均（元）")
    private BigDecimal uneven;

    /**
     * 高周转（元）
     */
    @ApiModelProperty("高周转（元）")
    private BigDecimal highTurnover;
}
