package com.biz.crm.tpm.business.activity.apply.rules.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author: chenlong
 * @date: 2022/11/8 16:21
 * @description: 活动申请规则主表vo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActivityApplyRulesVo", description = "活动申请规则主表vo")
public class ActivityApplyRulesVo extends TenantFlagOpVo {

    @ApiModelProperty(name = "申请规则名称", notes = "申请规则名称")
    private String applyRulesName;

    @ApiModelProperty(name = "申请规则编码", notes = "申请规则编码")
    private String applyRulesCode;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "销售部门编码", notes = "销售部门编码")
    private String salesOrgCode;

    @ApiModelProperty(name = "销售部门名称", notes = "销售部门名称")
    private String salesOrgName;

    @ApiModelProperty(name = "平台", notes = "平台")
    private String platformCode;

    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "电商渠道", notes = "电商渠道")
    private String estoreChannel;

    @ApiModelProperty(name = "电商渠道名称", notes = "电商渠道名称")
    private String estoreChannelName;

    @ApiModelProperty("申请金额计算公式")
    private String amountFormula;

    @ApiModelProperty("申请金额计算公式（展示用）")
    private String amountFormulaName;

    @ApiModelProperty("申请金额计算公式（json串）")
    private String amountFormulaJson;
}
