//package com.biz.crm.tpm.business.inventory.check.manage.feign.internal;
//
//
//import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
//import com.biz.crm.business.common.sdk.model.Result;
//import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityContractConfigDto;
//import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityContractConfigService;
//import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractConfigVo;
//
//import com.biz.crm.tpm.business.inventory.check.manage.feign.feign.TpmActivityContractConfigServiceFeign;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.collections.CollectionUtils;
//import org.apache.commons.lang3.StringUtils;
//import org.apache.commons.lang3.Validate;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.data.domain.Pageable;
//import org.springframework.stereotype.Service;
//import org.springframework.util.Assert;
//
//import java.util.List;
//
///**
// * 活动承接配置(TpmActivityContractConfig)表服务实现类
// *
// * @author heding
// * @create 2022-12-14 18:50:12
// */
//@Slf4j
//@Service
//public class TpmActivityContractConfigVoServiceImpl implements TpmActivityContractConfigService {
//
//    @Autowired(required = false)
//    private TpmActivityContractConfigServiceFeign tpmActivityContractConfigServiceFeign;
//
//    /**
//     * 按id查询详情
//     *
//     * @param id 主键ID
//     * @return com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractConfigVo
//     */
//    @Override
//    public TpmActivityContractConfigVo findById(String id) {
//        if (StringUtils.isEmpty(id)) {
//            return null;
//        }
//        Result<TpmActivityContractConfigVo> result = tpmActivityContractConfigServiceFeign.findById(id);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//        return result.getResult();
//    }
//
//    /**
//     * 删除
//     *
//     * @param idList 主键集合
//     */
//    @Override
//    public void delete(List<String> idList) {
//        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
//        Result result = tpmActivityContractConfigServiceFeign.delete(idList);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//    }
//
//    /**
//     * 新增数据
//     *
//     * @param dto 实体对象
//     * @return 新增结果
//     */
//    @Override
//    public void create(TpmActivityContractConfigDto dto) {
//        Validate.notNull(dto, "对象信息不能为空！");
//        Result<?> result = tpmActivityContractConfigServiceFeign.create(dto);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//    }
//
//    /**
//     * 基础共同校验
//     *
//     * @param dto 实体对象
//     */
//    private void commonValidate(TpmActivityContractConfigDto dto) {
//        Validate.notNull(dto, "对象信息不能为空！");
//        Validate.notBlank(dto.getBusinessFormatCode(), "业态不能为空！");
//        Validate.notBlank(dto.getContractWay(), "承接方式不能为空！");
//        Validate.notNull(dto.getStartTime(), "有效开始时间必须选择！");
//        Validate.notNull(dto.getEndTime(), "有效结束时间必须选择！");
//        if (org.springframework.util.CollectionUtils.isEmpty(dto.getTpmActivityContractCompanyDtoList())) {
//            return;
//        }
//        dto.getTpmActivityContractCompanyDtoList().forEach(tpmActivityContractCompanyDto -> {
//            Validate.notNull(tpmActivityContractCompanyDto, "对象信息不能为空！");
//            Validate.notBlank(tpmActivityContractCompanyDto.getSalesOrgCode(), "分子公司编码不能为空！");
//            Validate.notBlank(tpmActivityContractCompanyDto.getSalesOrgName(), "分子公司名称不能为空！");
//            Validate.notBlank(tpmActivityContractCompanyDto.getOrgCode(), "组织编码不能为空！");
//            Validate.notBlank(tpmActivityContractCompanyDto.getOrgName(), "组织名称不能为空！");
//        });
//    }
//
//    /**
//     * 分页查询数据
//     *
//     * @param pageable 分页对象
//     * @param dto      查询条件实体
//     * @return 所有数据
//     */
//    @Override
//    public Page<TpmActivityContractConfigVo> findByConditions(Pageable pageable, TpmActivityContractConfigDto dto) {
//        Result<Page<TpmActivityContractConfigVo>> result = tpmActivityContractConfigServiceFeign.findByConditions(pageable, dto);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//        return result.getResult();
//    }
//
//    /**
//     * 编辑数据
//     *
//     * @param dto 实体对象
//     * @return 编辑结果
//     */
//    @Override
//    public void update(TpmActivityContractConfigDto dto) {
//        commonValidate(dto);
//        Result<?> result = tpmActivityContractConfigServiceFeign.update(dto);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//    }
//
//    /**
//     * 启用
//     *
//     * @param idList 主键集合
//     * @return 启用结果
//     */
//    @Override
//    public void enable(List<String> idList) {
//        Validate.notEmpty(idList, "待启用的数据主键不能为空");
//        Result result = tpmActivityContractConfigServiceFeign.enable(idList);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//    }
//
//    /**
//     * 禁用
//     *
//     * @param idList 主键集合
//     * @return 禁用结果
//     */
//    @Override
//    public void disable(List<String> idList) {
//        Validate.notEmpty(idList, "待禁用的数据主键不能为空");
//        Result result = tpmActivityContractConfigServiceFeign.disable(idList);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//    }
//}
