package com.biz.crm.tpm.business.activity.contract.config.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityConfigRecordDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityConfigRecordService;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityConfigRecordVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 活动承接配置记录(TpmActivityConfigRecord)表相关的接口
 *
 * @author heding
 * @create 2022-11-23 9:01:38
 */
@RestController
@RequestMapping("/v1/tpmActivityConfigRecord")
@Slf4j
@Api(tags = "活动承接配置记录")
public class TpmActivityConfigRecordController {

    @Autowired
    private TpmActivityConfigRecordService tpmActivityConfigRecordService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<TpmActivityConfigRecordVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                    @ApiParam(name = "dto", value = "活动承接配置记录") TpmActivityConfigRecordDto dto) {
        try {
            Page<TpmActivityConfigRecordVo> page = tpmActivityConfigRecordService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 条件查询数据结果
     *
     * @param orgCode     组织编码
     * @param currentTime 当前时间
     * @return 结果
     */
    @ApiOperation(value = "条件查询数据结果")
    @GetMapping("findByOrgCodeAndDate")
    public Result<Boolean> findByOrgCodeAndDate(@ApiParam(name = "orgCode", value = "组织编码") @RequestParam(value = "orgCode") String orgCode,
                                                @ApiParam(name = "currentTime", value = "当前时间(yyyy-MM-dd)") @RequestParam(value = "currentTime", required = false) String currentTime) {
        try {
            Boolean result = tpmActivityConfigRecordService.findByOrgCodeAndDate(orgCode, currentTime);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
