package com.biz.crm.tpm.business.activity.contract.config.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityContractConfigDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityContractConfigService;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractConfigVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动承接配置(TpmActivityContractConfig)表相关的接口
 *
 * @author heding
 * @create 2022-11-21 11:01:38
 */
@RestController
@RequestMapping("/v1/tpmActivityContractConfig")
@Slf4j
@Api(tags = "TMP-活动承接配置")
public class TpmActivityContractConfigController {

    @Autowired
    private TpmActivityContractConfigService tpmActivityContractConfigService;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询数据")
    @GetMapping("findByConditions")
    public Result<Page<TpmActivityContractConfigVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                      @ApiParam(name = "dto", value = "活动承接配置主表") TpmActivityContractConfigDto dto) {
        try {
            Page<TpmActivityContractConfigVo> page = tpmActivityContractConfigService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<?> create(@ApiParam(name = "dto", value = "TPM-活动承接配置新增模板") @RequestBody TpmActivityContractConfigDto dto) {
        try {
            tpmActivityContractConfigService.create(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键集合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            tpmActivityContractConfigService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据回显
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<TpmActivityContractConfigVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            TpmActivityContractConfigVo result = tpmActivityContractConfigService.findById(id);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 编辑数据
     *
     * @param dto 实体对象
     * @return 编辑结果
     */
    @ApiOperation(value = "编辑数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "dto", value = "活动承接配置编辑") @RequestBody TpmActivityContractConfigDto dto) {
        try {
            tpmActivityContractConfigService.update(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param idList 主键集合
     * @return 启用结果
     */
    @ApiOperation(value = "批量根据id启用")
    @PatchMapping("enable")
    public Result<?> enable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        try {
            tpmActivityContractConfigService.enable(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param idList 主键集合
     * @return 禁用结果
     */
    @ApiOperation(value = "批量根据id禁用")
    @PatchMapping("disable")
    public Result<?> disable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        try {
            tpmActivityContractConfigService.disable(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
