package com.biz.crm.tpm.business.activity.contract.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author heding
 * @create 2022/11/21 9:21:44
 */
@ApiModel(value = "TpmActivityContractConfig", description = "TPM-库存盘点管理")
@TableName("tpm_activity_contract_config")
@Getter
@Setter
@Entity(name = "tpm_activity_contract_config")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_contract_config", comment = "TPM-活动承接配置")
@Table(name = "tpm_activity_contract_config", indexes = {@Index(name = "tpm_activity_contract_config_index1", columnList = "start_time"),
        @Index(name = "tpm_activity_contract_config_index2", columnList = "end_time"),
        @Index(name = "tpm_activity_contract_config_index3", columnList = "org_code"),
        @Index(name = "tpm_activity_contract_config_index4", columnList = "org_name")})
public class TpmActivityContractConfig extends TenantFlagOpEntity {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code",nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 有效开始时间
     */
    @ApiModelProperty(name = "有效开始时间", notes = "有效开始时间")
    @Column(name = "start_time", nullable = false, columnDefinition = "DATETIME COMMENT '有效开始时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;
    /**
     * 有效结束时间
     */
    @ApiModelProperty(name = "有效结束时间", notes = "有效结束时间")
    @Column(name = "end_time", nullable = false, columnDefinition = "DATETIME COMMENT '有效结束时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;
    /**
     * 承接方式
     */
    @ApiModelProperty(name = "承接方式", notes = "承接方式")
    @Column(name = "contract_way", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '承接方式'")
    private String contractWay;
    /**
     * 版本
     */
    @ApiModelProperty(name = "版本", notes = "版本")
    @Column(name = "version", nullable = false, length = 11, columnDefinition = "int(11) COMMENT '版本'")
    private Integer version;
    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码",notes = "组织编码")
    @Column(name = "org_code", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '组织编码'")
    private String orgCode;
    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称",notes = "组织名称")
    @Column(name = "org_name", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '组织名称'")
    private String orgName;
    /**
     * 分子公司编码
     */
    @ApiModelProperty(name = "分子公司编码",notes = "分子公司编码")
    @Column(name = "sales_org_code", nullable = false, length = 32, columnDefinition = "varchar(32) COMMENT '分子公司编码'")
    private String salesOrgCode;
    /**
     * 分子公司名称
     */
    @ApiModelProperty(name = "分子公司名称",notes = "分子公司名称")
    @Column(name = "sales_org_name", nullable = false, length = 64, columnDefinition = "varchar(64) COMMENT '分子公司名称'")
    private String salesOrgName;

}
