package com.biz.crm.tpm.business.activity.contract.config.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.contract.config.local.entity.TpmActivityConfigRecord;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityConfigRecordDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityConfigRecordVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 活动承接配置记录(TpmActivityConfigRecord)表mybatis访问层
 *
 * @author heding
 * @create 2022-11-22 18:01:44
 */
public interface TpmActivityConfigRecordMapper extends BaseMapper<TpmActivityConfigRecord> {
    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  查询实体
     * @return 所有数据
     */
    Page<TpmActivityConfigRecordVo> findByConditions(Page<TpmActivityConfigRecordVo> page, TpmActivityConfigRecordDto dto);
    /**
     * 条件查询数据
     *
     * @param orgCode
     * @param currentTime
     * @return
     */
    List<TpmActivityConfigRecord> findByOrgCodeAndDate(@Param("orgCode")String orgCode, @Param("currentTime") String currentTime);
}




