package com.biz.crm.tpm.business.activity.contract.config.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.contract.config.local.entity.TpmActivityContractConfig;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityContractConfigDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractConfigVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 活动承接配置(TpmActivityContractConfig)表mybatis访问层
 *
 * @author heding
 * @create 2022-11-21 11:01:44
 */
public interface TpmActivityContractConfigMapper extends BaseMapper<TpmActivityContractConfig> {

    /**
     * 分页查询数据
     *
     * @param page 分页对象
     * @param dto 查询条件实体
     * @return 所有数据
     */
    Page<TpmActivityContractConfigVo> findByConditions(@Param("page") Page<TpmActivityContractConfigVo> page, @Param("dto")TpmActivityContractConfigDto dto);
    /**
     * 条件查询数据
     *
     * @param orgCode
     * @param currentTime
     * @return
     */
    List<TpmActivityContractConfigVo> findByOrgCodeAndDate(@Param("orgCode")String orgCode, @Param("currentTime") String currentTime);
}
