package com.biz.crm.tpm.business.activity.contract.config.local.notifier.log;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityContractConfigDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.log.ActivityContractConfigLogEventDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.event.log.ActivityContractConfigEventListener;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractConfigVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author ：heding
 * @create ：Created in 2022/11/21 17:05
 * @description：日志监听实现
 */
@Component
public class ActivityContractConfigEventListenerImpl implements ActivityContractConfigEventListener {
    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 创建事件
     *
     * @param eventDto
     */
    @Override
    public void onCreate(ActivityContractConfigLogEventDto eventDto) {
        TpmActivityContractConfigVo newest = eventDto.getNewest();
        TpmActivityContractConfigVo original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 删除事件
     *
     * @param eventDto
     */
    @Override
    public void onDelete(ActivityContractConfigLogEventDto eventDto) {
        TpmActivityContractConfigVo newest = eventDto.getNewest();
        TpmActivityContractConfigVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 更新日志
     *
     * @param eventDto
     */
    @Override
    public void onUpdate(ActivityContractConfigLogEventDto eventDto) {
        TpmActivityContractConfigVo newest = eventDto.getNewest();
        TpmActivityContractConfigVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 启用
     *
     * @param eventDto
     */
    @Override
    public void onEnable(ActivityContractConfigLogEventDto eventDto) {
        TpmActivityContractConfigVo newest = eventDto.getNewest();
        TpmActivityContractConfigVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只传单个字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", original.getEnableStatus());
        newObject.put("enableStatus", newest.getEnableStatus());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 禁用
     *
     * @param eventDto
     */
    @Override
    public void onDisable(ActivityContractConfigLogEventDto eventDto) {
        TpmActivityContractConfigVo newest = eventDto.getNewest();
        TpmActivityContractConfigVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只传单个字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", original.getEnableStatus());
        newObject.put("enableStatus", newest.getEnableStatus());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
