package com.biz.crm.tpm.business.activity.contract.config.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author ：heding
 * @create ：Created in 2022/11/23 10:27:56
 * @description：活动承接配置
 */
@Component
@Slf4j
public class ActivityContractConfigRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_activity_contract_config_data_view";
    }

    @Override
    public String desc() {
        return "TPM-活动承接配置";
    }

    @Override
    public String buildSql() {
        return "select t.*,DATE_FORMAT(t.start_time,'%Y-%m-%d') AS start_time_format,DATE_FORMAT(t.end_time,'%Y-%m-%d') AS end_time_format" +
                " from tpm_activity_contract_config t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode()+"'";
    }
}
