package com.biz.crm.tpm.business.activity.contract.config.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.contract.config.local.entity.TpmActivityConfigRecord;
import com.biz.crm.tpm.business.activity.contract.config.local.mapper.TpmActivityConfigRecordMapper;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityConfigRecordDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityConfigRecordVo;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 活动承接配置记录(TpmActivityConfigRecord)表数据库访问层
 *
 * @author heding
 * @create 2022-11-22 18:50:12
 */
@Component
public class TpmActivityConfigRecordRepository extends ServiceImpl<TpmActivityConfigRecordMapper, TpmActivityConfigRecord> {

    @Autowired(required = false)
    private TpmActivityConfigRecordMapper tpmActivityConfigRecordMapper;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    public Page<TpmActivityConfigRecordVo> findByConditions(Pageable pageable, TpmActivityConfigRecordDto dto) {
        Page<TpmActivityConfigRecordVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<TpmActivityConfigRecordVo> pageList = tpmActivityConfigRecordMapper.findByConditions(page, dto);
        return pageList;
    }
    /**
     * 条件查询数据
     *
     * @param orgCode     组织编码
     * @param currentTime 当前时间
     * @return 结果
     */
    public List<TpmActivityConfigRecord> findByOrgCodeAndDate(String orgCode, String currentTime) {
        return tpmActivityConfigRecordMapper.findByOrgCodeAndDate(orgCode, currentTime);
    }
}
