package com.biz.crm.tpm.business.activity.contract.config.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.contract.config.local.entity.TpmActivityConfigRecord;
import com.biz.crm.tpm.business.activity.contract.config.local.entity.TpmActivityContractConfig;
import com.biz.crm.tpm.business.activity.contract.config.local.mapper.TpmActivityContractConfigMapper;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityContractConfigDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 活动承接配置(TpmActivityContractConfig)表数据库访问层
 *
 * @author heding
 * @create 2022-11-16 14:50:12
 */
@Component
public class TpmActivityContractConfigRepository extends ServiceImpl<TpmActivityContractConfigMapper, TpmActivityContractConfig> {
    @Autowired(required = false)
    private TpmActivityContractConfigMapper tpmActivityContractConfigMapper;



    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param dto 查询条件实体
     * @return
     */
    public Page<TpmActivityContractConfigVo> findByConditions(Pageable pageable, TpmActivityContractConfigDto dto) {
        Page<TpmActivityContractConfigVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<TpmActivityContractConfigVo> pageList = tpmActivityContractConfigMapper.findByConditions(page, dto);
        return pageList;
    }

    /**
     * 条件查询
     *
     * @author huojia
     * @date 2022/12/27 14:29
     * @param dto
     * @return java.util.List<com.biz.crm.tpm.business.activity.contract.config.local.entity.TpmActivityContractConfig>
     **/
    public List<TpmActivityContractConfig> listByConditions(TpmActivityContractConfigDto dto) {
        if (StringUtils.isEmpty(dto.getBusinessFormatCode()) || StringUtils.isEmpty(dto.getOrgCode())) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(TpmActivityContractConfig::getBusinessFormatCode, dto.getBusinessFormatCode())
                .in(TpmActivityContractConfig::getOrgCode, dto.getOrgCodeList())
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .ge(TpmActivityContractConfig::getEndTime, dto.getQueryTime())
                .le(TpmActivityContractConfig::getStartTime, dto.getQueryTime())
                .list();
    }
    /**
     * 条件查询数据
     *
     * @param orgCode
     * @param currentTime
     * @return
     */
    public List<TpmActivityContractConfigVo> findByOrgCodeAndDate(String orgCode, String currentTime) {
        return tpmActivityContractConfigMapper.findByOrgCodeAndDate(orgCode,currentTime);
    }
}
