package com.biz.crm.tpm.business.activity.contract.config.local.service.internal;


import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.contract.config.local.entity.TpmActivityConfigRecord;
import com.biz.crm.tpm.business.activity.contract.config.local.repository.TpmActivityConfigRecordRepository;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityConfigRecordDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityConfigRecordService;
import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityContractConfigService;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityConfigRecordVo;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * 活动承接配置记录(TpmActivityConfigRecord)表服务实现类
 *
 * @author heding
 * @create 2022-11-22 17:50:12
 */
@Service("tpmActivityConfigRecordService")
public class TpmActivityConfigRecordServiceImpl implements TpmActivityConfigRecordService {

    @Autowired(required = false)
    private TpmActivityConfigRecordRepository tpmActivityConfigRecordRepository;
    @Autowired(required = false)
    private TpmActivityContractConfigService activityContractConfigService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @Override
    public Page<TpmActivityConfigRecordVo> findByConditions(Pageable pageable, TpmActivityConfigRecordDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new TpmActivityConfigRecordDto();
        }
        return (Page<TpmActivityConfigRecordVo>) tpmActivityConfigRecordRepository.findByConditions(pageable, dto);
    }

    /**
     * 条件查询数据
     *
     * @param orgCode     组织编码
     * @param currentTime 当前时间
     * @return 结果
     */
    @Override
    public Boolean findByOrgCodeAndDate(String orgCode, String currentTime) {
        Validate.notBlank(orgCode, "组织编码不能为空！");
        if (StringUtils.isNotEmpty(currentTime)) {
            Validate.isTrue(isFlag(currentTime), "时间格式错误，应为yyyy-MM-dd");
        } else {
            currentTime = DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        }
        List<TpmActivityContractConfigVo> tpmActivityContractConfigVos = activityContractConfigService.findByOrgCodeAndDate(orgCode, currentTime);
        if (CollectionUtils.isNotEmpty(tpmActivityContractConfigVos)) {
            return true;
        }
        List<TpmActivityConfigRecord>  tpmActivityConfigRecords = tpmActivityConfigRecordRepository.findByOrgCodeAndDate(orgCode, currentTime);
        if (CollectionUtils.isNotEmpty(tpmActivityConfigRecords)) {
            return true;
        }
        return false;
    }

    /**
     * 保存历史配置
     *
     * @param record
     */
    @Override
    public void saveData(TpmActivityConfigRecordDto record) {
        tpmActivityConfigRecordRepository.save(nebulaToolkitService.copyObjectByWhiteList(record, TpmActivityConfigRecord.class, LinkedHashSet.class, ArrayList.class));
    }

    /**
     * 时间格式判断
     *
     * @param currentTime
     * @return
     */
    private boolean isFlag(String currentTime) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        boolean flag = true;
        try {
            dtf.parse(currentTime);
        } catch (Exception e) {
            flag = false;
        }
        return flag;
    }
}




