package com.biz.crm.tpm.business.activity.contract.config.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.contract.config.local.entity.TpmActivityConfigRecord;
import com.biz.crm.tpm.business.activity.contract.config.local.entity.TpmActivityContractConfig;
import com.biz.crm.tpm.business.activity.contract.config.local.repository.TpmActivityContractConfigRepository;
import com.biz.crm.tpm.business.activity.contract.config.sdk.constant.ActivityContractConfigConstant;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityConfigRecordDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityContractCompanyDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityContractConfigDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.log.ActivityContractConfigLogEventDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.event.log.ActivityContractConfigEventListener;
import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityConfigRecordService;
import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityContractConfigService;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractCompanyVo;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;


/**
 * 活动承接配置(TpmActivityContractConfig)表服务实现类
 *
 * @author heding
 * @create 2022-11-19 14:50:12
 */
@Service("tpmActivityContractConfigService")
public class TpmActivityContractConfigServiceImpl implements TpmActivityContractConfigService {
    @Autowired(required = false)
    private TpmActivityContractConfigRepository tpmActivityContractConfigRepository;
    @Autowired(required = false)
    private TpmActivityConfigRecordService activityConfigRecordService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required = false)
    private OrgVoService orgVoService;

    /**
     * 通过主键查询单条数据回显
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public TpmActivityContractConfigVo findById(String id) {
        // 判断id是否为空
        if (StringUtils.isBlank(id)) {
            return null;
        }
        // 根据id查询活动承接配置主表信息
        TpmActivityContractConfig activityContractConfig = tpmActivityContractConfigRepository.getById(id);
        // 判断是否存在该数据
        if (ObjectUtils.isEmpty(activityContractConfig)) {
            return null;
        }
        TpmActivityContractConfigVo tpmActivityContractConfigVo = nebulaToolkitService.copyObjectByWhiteList(activityContractConfig, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class);
        List<TpmActivityContractCompanyVo> list = new ArrayList<>();
        TpmActivityContractCompanyVo tpmActivityContractCompanyVo = new TpmActivityContractCompanyVo();
        tpmActivityContractCompanyVo.setOrgCode(tpmActivityContractConfigVo.getOrgCode());
        tpmActivityContractCompanyVo.setOrgName(tpmActivityContractConfigVo.getOrgName());
        tpmActivityContractCompanyVo.setSalesOrgCode(tpmActivityContractConfigVo.getSalesOrgCode());
        tpmActivityContractCompanyVo.setSalesOrgName(tpmActivityContractConfigVo.getSalesOrgName());
        list.add(tpmActivityContractCompanyVo);
        tpmActivityContractConfigVo.setTpmActivityContractCompanyDtoList(list);
        return tpmActivityContractConfigVo;
    }

    /**
     * 删除数据
     *
     * @param idList 主键集合
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<TpmActivityContractConfig> businessPolicyList1 = tpmActivityContractConfigRepository.listByIds(idList);
        Validate.isTrue(!CollectionUtils.isEmpty(businessPolicyList1), "要删除的数据不能为空");
        List<TpmActivityContractConfig> tpmActivityContractConfigList = new ArrayList<>();
        businessPolicyList1.forEach(item -> {
            TpmActivityContractConfig tpmActivityContractConfig = new TpmActivityContractConfig();
            tpmActivityContractConfig.setId(item.getId());
            tpmActivityContractConfig.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            tpmActivityContractConfigList.add(tpmActivityContractConfig);
            //删除业务日志
            ActivityContractConfigLogEventDto logEventDto = new ActivityContractConfigLogEventDto();
            TpmActivityContractConfigVo oldVo = nebulaToolkitService.copyObjectByWhiteList(item, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class);
            logEventDto.setOriginal(oldVo);
            TpmActivityContractConfigVo tpmActivityContractConfigVo = nebulaToolkitService.copyObjectByWhiteList(item, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class);
            tpmActivityContractConfigVo.setDelFlag(tpmActivityContractConfig.getDelFlag());
            logEventDto.setNewest(tpmActivityContractConfigVo);
            SerializableBiConsumer<ActivityContractConfigEventListener, ActivityContractConfigLogEventDto> onDelete =
                    ActivityContractConfigEventListener::onDelete;
            nebulaNetEventClient.publish(logEventDto, ActivityContractConfigEventListener.class, onDelete);
        });
        tpmActivityContractConfigRepository.updateBatchById(tpmActivityContractConfigList);
    }

    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void create(TpmActivityContractConfigDto dto) {
        createValidate(dto);
        //活动承接配置主表
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setVersion(ActivityContractConfigConstant.INITIAL_VERSION);
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        ArrayList<TpmActivityContractConfig> list = new ArrayList<>();
        dto.getTpmActivityContractCompanyDtoList().forEach(company -> {
            TpmActivityContractConfig tpmActivityContractConfig = nebulaToolkitService.copyObjectByWhiteList(dto, TpmActivityContractConfig.class, LinkedHashSet.class, ArrayList.class);
            tpmActivityContractConfig.setSalesOrgCode(company.getSalesOrgCode());
            tpmActivityContractConfig.setSalesOrgName(company.getSalesOrgName());
            tpmActivityContractConfig.setOrgCode(company.getOrgCode());
            tpmActivityContractConfig.setOrgName(company.getOrgName());
            list.add(tpmActivityContractConfig);

            //新增业务日志
            ActivityContractConfigLogEventDto logEventDto = new ActivityContractConfigLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(nebulaToolkitService.copyObjectByWhiteList(tpmActivityContractConfig, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class));
            SerializableBiConsumer<ActivityContractConfigEventListener, ActivityContractConfigLogEventDto> onCreate =
                    ActivityContractConfigEventListener::onCreate;
            nebulaNetEventClient.publish(logEventDto, ActivityContractConfigEventListener.class, onCreate);
        });
        tpmActivityContractConfigRepository.saveBatch(list);


    }

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    @Override
    public Page<TpmActivityContractConfigVo> findByConditions(Pageable pageable, TpmActivityContractConfigDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new TpmActivityContractConfigDto();
        }
        return tpmActivityContractConfigRepository.findByConditions(pageable, dto);
    }

    /**
     * 编辑数据
     *
     * @param dto 实体对象
     * @return 编辑结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(TpmActivityContractConfigDto dto) {
        this.updateValidate(dto);
        // 活动承接配置主表
        TpmActivityContractConfigVo oldVo = findById(dto.getId());
        if (ObjectUtils.isEmpty(oldVo)) {
            throw new RuntimeException("修改数据失败，原数据不存在！");
        }
        Integer version = oldVo.getVersion();
        // 保存活动承接配置记录
        saveActivityConfigRecord(oldVo, version);
        //活动承接配置主表
        dto.setVersion(version + 1);
        ArrayList<TpmActivityContractConfig> list = new ArrayList<>();
        List<TpmActivityContractCompanyDto> dtoList = dto.getTpmActivityContractCompanyDtoList();
        for (int i = 0; i < dtoList.size(); i++) {
            TpmActivityContractConfig tpmActivityContractConfig = nebulaToolkitService.copyObjectByWhiteList(dto, TpmActivityContractConfig.class, LinkedHashSet.class, ArrayList.class);
            TpmActivityContractCompanyDto contractCompanyDto = dtoList.get(i);
            tpmActivityContractConfig.setSalesOrgCode(contractCompanyDto.getSalesOrgCode());
            tpmActivityContractConfig.setSalesOrgName(contractCompanyDto.getSalesOrgName());
            tpmActivityContractConfig.setOrgCode(contractCompanyDto.getOrgCode());
            tpmActivityContractConfig.setOrgName(contractCompanyDto.getOrgName());
            if (i > 0) {
                tpmActivityContractConfig.setId(null);
                tpmActivityContractConfig.setVersion(ActivityContractConfigConstant.INITIAL_VERSION);
                list.add(tpmActivityContractConfig);
            } else {
                tpmActivityContractConfigRepository.updateById(tpmActivityContractConfig);
            }

            //编辑业务日志
            ActivityContractConfigLogEventDto logEventDto = new ActivityContractConfigLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(nebulaToolkitService.copyObjectByWhiteList(tpmActivityContractConfig, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class));
            SerializableBiConsumer<ActivityContractConfigEventListener, ActivityContractConfigLogEventDto> onUpdate =
                    ActivityContractConfigEventListener::onUpdate;
            nebulaNetEventClient.publish(logEventDto, ActivityContractConfigEventListener.class, onUpdate);
        }
        tpmActivityContractConfigRepository.saveBatch(list);


    }

    /**
     * 保存活动承接配置记录
     *
     * @param oldVo 老数据对象
     */
    private void saveActivityConfigRecord(TpmActivityContractConfigVo oldVo, Integer version) {
        TpmActivityConfigRecordDto record = nebulaToolkitService.copyObjectByWhiteList(oldVo, TpmActivityConfigRecordDto.class, LinkedHashSet.class, ArrayList.class);
        record.setActivityId(oldVo.getId());
        record.setVersion(version);
        record.setId(null);
        activityConfigRecordService.saveData(record);

    }

    /**
     * 启用
     *
     * @param idList 主键集合
     * @return 启用结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void enable(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "启用数据时，主键集合不能为空！");
        List<TpmActivityContractConfig> tpmActivityContractConfigList = tpmActivityContractConfigRepository.listByIds(idList);
        Validate.isTrue(!CollectionUtils.isEmpty(tpmActivityContractConfigList), "启用的数据不能为空");
        ArrayList<TpmActivityContractConfig> activityContractConfigList = new ArrayList<>();
        tpmActivityContractConfigList.forEach(item -> {
            TpmActivityContractConfig tpmActivityContractConfig = new TpmActivityContractConfig();
            tpmActivityContractConfig.setId(item.getId());
            tpmActivityContractConfig.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            activityContractConfigList.add(tpmActivityContractConfig);

            //启用业务日志
            ActivityContractConfigLogEventDto logEventDto = new ActivityContractConfigLogEventDto();
            TpmActivityContractConfigVo oldVo = nebulaToolkitService.copyObjectByWhiteList(item, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class);
            logEventDto.setOriginal(oldVo);
            TpmActivityContractConfigVo tpmActivityContractConfigVo = nebulaToolkitService.copyObjectByWhiteList(item, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class);
            tpmActivityContractConfigVo.setEnableStatus(tpmActivityContractConfig.getEnableStatus());
            logEventDto.setNewest(tpmActivityContractConfigVo);
            SerializableBiConsumer<ActivityContractConfigEventListener, ActivityContractConfigLogEventDto> onEnable =
                    ActivityContractConfigEventListener::onEnable;
            nebulaNetEventClient.publish(logEventDto, ActivityContractConfigEventListener.class, onEnable);
        });
        tpmActivityContractConfigRepository.updateBatchById(activityContractConfigList);
    }

    /**
     * 禁用
     *
     * @param idList 主键集合
     * @return 禁用结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void disable(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "禁用数据时，主键集合不能为空！");
        List<TpmActivityContractConfig> tpmActivityContractConfigList = tpmActivityContractConfigRepository.listByIds(idList);
        Validate.isTrue(!CollectionUtils.isEmpty(tpmActivityContractConfigList), "禁用的数据不能为空");
        ArrayList<TpmActivityContractConfig> activityContractConfigList = new ArrayList<>();
        tpmActivityContractConfigList.forEach(item -> {
            TpmActivityContractConfig tpmActivityContractConfig = new TpmActivityContractConfig();
            tpmActivityContractConfig.setId(item.getId());
            tpmActivityContractConfig.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            activityContractConfigList.add(tpmActivityContractConfig);

            //禁用业务日志
            ActivityContractConfigLogEventDto logEventDto = new ActivityContractConfigLogEventDto();
            TpmActivityContractConfigVo oldVo = nebulaToolkitService.copyObjectByWhiteList(item, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class);
            logEventDto.setOriginal(oldVo);
            TpmActivityContractConfigVo tpmActivityContractConfigVo = nebulaToolkitService.copyObjectByWhiteList(item, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class);
            tpmActivityContractConfigVo.setEnableStatus(tpmActivityContractConfig.getEnableStatus());
            logEventDto.setNewest(tpmActivityContractConfigVo);
            SerializableBiConsumer<ActivityContractConfigEventListener, ActivityContractConfigLogEventDto> onDisable =
                    ActivityContractConfigEventListener::onDisable;
            nebulaNetEventClient.publish(logEventDto, ActivityContractConfigEventListener.class, onDisable);
        });
        tpmActivityContractConfigRepository.updateBatchById(activityContractConfigList);
    }

    @Override
    public List<TpmActivityContractConfigVo> listByConditions(TpmActivityContractConfigDto dto) {
        if (ObjectUtils.isEmpty(dto)) {
            return Lists.newArrayList();
        }
        if (StringUtils.isEmpty(dto.getBusinessFormatCode()) || StringUtils.isEmpty(dto.getOrgCode())) {
            return Lists.newArrayList();
        }
        List<String> orgCodeList = new ArrayList<>();
        orgCodeList.add(dto.getOrgCode());
        List<OrgVo> allParent = orgVoService.findAllParentByOrgCode(dto.getOrgCode());
        if (!CollectionUtils.isEmpty(allParent)) {
            orgCodeList.addAll(allParent.stream().map(OrgVo::getOrgCode).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        dto.setOrgCodeList(orgCodeList);
        dto.setQueryTime(DateUtil.getDate(DateUtil.date_yyyy_MM_dd_HH_mm_ss));
        List<TpmActivityContractConfig> tpmActivityContractConfigs = tpmActivityContractConfigRepository.listByConditions(dto);
        if (CollectionUtils.isEmpty(tpmActivityContractConfigs)) {
            return Lists.newArrayList();
        }
        return (List<TpmActivityContractConfigVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                tpmActivityContractConfigs, TpmActivityContractConfig.class, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class
        );
    }
    /**
     * 条件查询数据
     *
     * @param orgCode
     * @param currentTime
     * @return
     */
    @Override
    public List<TpmActivityContractConfigVo> findByOrgCodeAndDate(String orgCode, String currentTime) {
        Validate.notBlank(orgCode,"组织编码不能为空！");
        Validate.notBlank(currentTime,"当前时间不能为空！");
        return tpmActivityContractConfigRepository.findByOrgCodeAndDate(orgCode,currentTime);
    }

    /**
     * 创建验证
     *
     * @param dto
     */
    private void createValidate(TpmActivityContractConfigDto dto) {
        Validate.notNull(dto, "新增时，对象信息不能为空！");
        Validate.notBlank(dto.getBusinessFormatCode(), "新增数据时，业态不能为空！");
        Validate.notBlank(dto.getContractWay(), "新增数据时，承接方式不能为空！");
        Date startTime = dto.getStartTime();
        Validate.notNull(startTime, "新增数据时，有效开始时间必须选择！");
        Date endTime = dto.getEndTime();
        Validate.notNull(endTime, "新增数据时，有效结束时间必须选择！");
        Validate.isTrue(!startTime.after(endTime),"有效开始时间不能在有效结束时间之后！");
        List<TpmActivityContractCompanyDto> tpmActivityContractCompanyDtoList = dto.getTpmActivityContractCompanyDtoList();
        if (CollectionUtils.isEmpty(tpmActivityContractCompanyDtoList)) {
            throw new RuntimeException("请至少选一个公司维护");
        }
        List<String> list = new LinkedList<>();
        for (TpmActivityContractCompanyDto tpmActivityContractCompanyDto : tpmActivityContractCompanyDtoList) {
            Validate.notNull(tpmActivityContractCompanyDto, "新增时，对象信息不能为空！");
            String orgCode = tpmActivityContractCompanyDto.getOrgCode();
            Validate.notBlank(orgCode, "新增数据时，组织编码不能为空！");
            Validate.isTrue(!list.contains(orgCode),"请不要重复选择相同的组织！");
            list.add(orgCode);
            Validate.notBlank(tpmActivityContractCompanyDto.getOrgName(), "新增数据时，组织名称不能为空！");
            Validate.notBlank(tpmActivityContractCompanyDto.getSalesOrgCode(), "新增数据时，分子公司编码不能为空！");
            Validate.notBlank(tpmActivityContractCompanyDto.getSalesOrgName(), "新增数据时，分子公司名称不能为空！");
        }
    }

    /**
     * 修改验证
     *
     * @param dto
     */
    private void updateValidate(TpmActivityContractConfigDto dto) {
        Validate.notNull(dto, "修改时，对象信息不能为空！");
        Validate.notBlank(dto.getId(), "修改数据时，主键id不能为空！");
        Validate.notBlank(dto.getTenantCode(), "修改数据时，租户编号不能为空！");
        Validate.notBlank(dto.getBusinessFormatCode(), "修改数据时，业态不能为空！");
        Validate.notBlank(dto.getContractWay(), "修改数据时，承接方式不能为空！");
        Date startTime = dto.getStartTime();
        Validate.notNull(startTime, "修改数据时，有效开始时间必须选择！");
        Date endTime = dto.getEndTime();
        Validate.notNull(endTime, "修改数据时，有效结束时间必须选择！");
        Validate.isTrue(!startTime.after(endTime),"有效开始时间不能在有效结束时间之后！");
        List<TpmActivityContractCompanyDto> tpmActivityContractCompanyDtoList = dto.getTpmActivityContractCompanyDtoList();
        if (CollectionUtils.isEmpty(tpmActivityContractCompanyDtoList)) {
            throw new RuntimeException("请至少选一个公司维护");
        }
        List<String> list = new LinkedList<>();
        for (TpmActivityContractCompanyDto tpmActivityContractCompanyDto : tpmActivityContractCompanyDtoList) {
            Validate.notNull(tpmActivityContractCompanyDto, "修改数据时，对象信息不能为空！");
            String orgCode = tpmActivityContractCompanyDto.getOrgCode();
            Validate.notBlank(orgCode, "修改数据时，组织编码不能为空！");
            Validate.isTrue(!list.contains(orgCode),"请不要重复选择相同的组织！");
            list.add(orgCode);
            Validate.notBlank(tpmActivityContractCompanyDto.getOrgName(), "修改数据时，组织名称不能为空！");
            Validate.notBlank(tpmActivityContractCompanyDto.getSalesOrgCode(), "修改数据时，分子公司编码不能为空！");
            Validate.notBlank(tpmActivityContractCompanyDto.getSalesOrgName(), "修改数据时，分子公司名称不能为空！");
        }
    }
}
