/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.config.local.service.internal;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.contract.config.local.entity.TpmActivityConfigRecord;
import com.biz.crm.tpm.business.activity.contract.config.local.repository.TpmActivityConfigRecordRepository;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityConfigRecordDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityConfigRecordService;
import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityContractConfigService;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityConfigRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="tpmActivityConfigRecordService")
public class TpmActivityConfigRecordServiceImpl
implements TpmActivityConfigRecordService {
    @Autowired(required=false)
    private TpmActivityConfigRecordRepository tpmActivityConfigRecordRepository;
    @Autowired(required=false)
    private TpmActivityContractConfigService activityContractConfigService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<TpmActivityConfigRecordVo> findByConditions(Pageable pageable, TpmActivityConfigRecordDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmActivityConfigRecordDto();
        }
        return (Page)this.tpmActivityConfigRecordRepository.findByConditions(pageable, dto);
    }

    public Boolean findByOrgCodeAndDate(String orgCode, String currentTime) {
        Validate.notBlank((CharSequence)orgCode, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)currentTime)) {
            Validate.isTrue((boolean)this.isFlag(currentTime), (String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3ayyyy-MM-dd", (Object[])new Object[0]);
        } else {
            currentTime = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        }
        List tpmActivityContractConfigVos = this.activityContractConfigService.findByOrgCodeAndDate(orgCode, currentTime);
        if (CollectionUtils.isNotEmpty((Collection)tpmActivityContractConfigVos)) {
            return true;
        }
        List<TpmActivityConfigRecord> tpmActivityConfigRecords = this.tpmActivityConfigRecordRepository.findByOrgCodeAndDate(orgCode, currentTime);
        if (CollectionUtils.isNotEmpty(tpmActivityConfigRecords)) {
            return true;
        }
        return false;
    }

    public void saveData(TpmActivityConfigRecordDto record) {
        this.tpmActivityConfigRecordRepository.save(this.nebulaToolkitService.copyObjectByWhiteList((Object)record, TpmActivityConfigRecord.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    private boolean isFlag(String currentTime) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        boolean flag = true;
        try {
            dtf.parse(currentTime);
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }
}

