/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.config.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.contract.config.local.entity.TpmActivityContractConfig;
import com.biz.crm.tpm.business.activity.contract.config.local.repository.TpmActivityContractConfigRepository;
import com.biz.crm.tpm.business.activity.contract.config.sdk.constant.ActivityContractConfigConstant;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityConfigRecordDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityContractCompanyDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityContractConfigDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.log.ActivityContractConfigLogEventDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.event.log.ActivityContractConfigEventListener;
import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityConfigRecordService;
import com.biz.crm.tpm.business.activity.contract.config.sdk.service.TpmActivityContractConfigService;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractCompanyVo;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tpmActivityContractConfigService")
public class TpmActivityContractConfigServiceImpl
implements TpmActivityContractConfigService {
    @Autowired(required=false)
    private TpmActivityContractConfigRepository tpmActivityContractConfigRepository;
    @Autowired(required=false)
    private TpmActivityConfigRecordService activityConfigRecordService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private OrgVoService orgVoService;

    public TpmActivityContractConfigVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TpmActivityContractConfig activityContractConfig = (TpmActivityContractConfig)((Object)this.tpmActivityContractConfigRepository.getById((Serializable)((Object)id)));
        if (ObjectUtils.isEmpty((Object)((Object)activityContractConfig))) {
            return null;
        }
        TpmActivityContractConfigVo tpmActivityContractConfigVo = (TpmActivityContractConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityContractConfig, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        ArrayList<TpmActivityContractCompanyVo> list = new ArrayList<TpmActivityContractCompanyVo>();
        TpmActivityContractCompanyVo tpmActivityContractCompanyVo = new TpmActivityContractCompanyVo();
        tpmActivityContractCompanyVo.setOrgCode(tpmActivityContractConfigVo.getOrgCode());
        tpmActivityContractCompanyVo.setOrgName(tpmActivityContractConfigVo.getOrgName());
        tpmActivityContractCompanyVo.setSalesOrgCode(tpmActivityContractConfigVo.getSalesOrgCode());
        tpmActivityContractCompanyVo.setSalesOrgName(tpmActivityContractConfigVo.getSalesOrgName());
        list.add(tpmActivityContractCompanyVo);
        tpmActivityContractConfigVo.setTpmActivityContractCompanyDtoList(list);
        return tpmActivityContractConfigVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List businessPolicyList1 = this.tpmActivityContractConfigRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessPolicyList1) ? 1 : 0) != 0, (String)"\u8981\u5220\u9664\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList tpmActivityContractConfigList = new ArrayList();
        businessPolicyList1.forEach(item -> {
            TpmActivityContractConfig tpmActivityContractConfig = new TpmActivityContractConfig();
            tpmActivityContractConfig.setId(item.getId());
            tpmActivityContractConfig.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            tpmActivityContractConfigList.add(tpmActivityContractConfig);
            ActivityContractConfigLogEventDto logEventDto = new ActivityContractConfigLogEventDto();
            TpmActivityContractConfigVo oldVo = (TpmActivityContractConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldVo);
            TpmActivityContractConfigVo tpmActivityContractConfigVo = (TpmActivityContractConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmActivityContractConfigVo.setDelFlag(tpmActivityContractConfig.getDelFlag());
            logEventDto.setNewest(tpmActivityContractConfigVo);
            SerializableBiConsumer & Serializable onDelete = ActivityContractConfigEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityContractConfigEventListener.class, (SerializableBiConsumer)onDelete);
        });
        this.tpmActivityContractConfigRepository.updateBatchById(tpmActivityContractConfigList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(TpmActivityContractConfigDto dto) {
        this.createValidate(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setVersion(ActivityContractConfigConstant.INITIAL_VERSION);
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        ArrayList list = new ArrayList();
        dto.getTpmActivityContractCompanyDtoList().forEach(company -> {
            TpmActivityContractConfig tpmActivityContractConfig = (TpmActivityContractConfig)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmActivityContractConfig.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            tpmActivityContractConfig.setSalesOrgCode(company.getSalesOrgCode());
            tpmActivityContractConfig.setSalesOrgName(company.getSalesOrgName());
            tpmActivityContractConfig.setOrgCode(company.getOrgCode());
            tpmActivityContractConfig.setOrgName(company.getOrgName());
            list.add(tpmActivityContractConfig);
            ActivityContractConfigLogEventDto logEventDto = new ActivityContractConfigLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest((TpmActivityContractConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)tpmActivityContractConfig, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            SerializableBiConsumer & Serializable onCreate = ActivityContractConfigEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityContractConfigEventListener.class, (SerializableBiConsumer)onCreate);
        });
        this.tpmActivityContractConfigRepository.saveBatch(list);
    }

    public Page<TpmActivityContractConfigVo> findByConditions(Pageable pageable, TpmActivityContractConfigDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmActivityContractConfigDto();
        }
        return this.tpmActivityContractConfigRepository.findByConditions(pageable, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(TpmActivityContractConfigDto dto) {
        this.updateValidate(dto);
        TpmActivityContractConfigVo oldVo = this.findById(dto.getId());
        if (ObjectUtils.isEmpty((Object)oldVo)) {
            throw new RuntimeException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u539f\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        Integer version = oldVo.getVersion();
        this.saveActivityConfigRecord(oldVo, version);
        dto.setVersion(Integer.valueOf(version + 1));
        ArrayList<TpmActivityContractConfig> list = new ArrayList<TpmActivityContractConfig>();
        List dtoList = dto.getTpmActivityContractCompanyDtoList();
        for (int i = 0; i < dtoList.size(); ++i) {
            TpmActivityContractConfig tpmActivityContractConfig = (TpmActivityContractConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmActivityContractConfig.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            TpmActivityContractCompanyDto contractCompanyDto = (TpmActivityContractCompanyDto)dtoList.get(i);
            tpmActivityContractConfig.setSalesOrgCode(contractCompanyDto.getSalesOrgCode());
            tpmActivityContractConfig.setSalesOrgName(contractCompanyDto.getSalesOrgName());
            tpmActivityContractConfig.setOrgCode(contractCompanyDto.getOrgCode());
            tpmActivityContractConfig.setOrgName(contractCompanyDto.getOrgName());
            if (i > 0) {
                tpmActivityContractConfig.setId(null);
                tpmActivityContractConfig.setVersion(ActivityContractConfigConstant.INITIAL_VERSION);
                list.add(tpmActivityContractConfig);
            } else {
                this.tpmActivityContractConfigRepository.updateById((Object)tpmActivityContractConfig);
            }
            ActivityContractConfigLogEventDto logEventDto = new ActivityContractConfigLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest((TpmActivityContractConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)tpmActivityContractConfig, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            SerializableBiConsumer & Serializable onUpdate = ActivityContractConfigEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityContractConfigEventListener.class, (SerializableBiConsumer)onUpdate);
        }
        this.tpmActivityContractConfigRepository.saveBatch(list);
    }

    private void saveActivityConfigRecord(TpmActivityContractConfigVo oldVo, Integer version) {
        TpmActivityConfigRecordDto record = (TpmActivityConfigRecordDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldVo, TpmActivityConfigRecordDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        record.setActivityId(oldVo.getId());
        record.setVersion(version);
        record.setId(null);
        this.activityConfigRecordService.saveData(record);
    }

    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List tpmActivityContractConfigList = this.tpmActivityContractConfigRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)tpmActivityContractConfigList) ? 1 : 0) != 0, (String)"\u542f\u7528\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList activityContractConfigList = new ArrayList();
        tpmActivityContractConfigList.forEach(item -> {
            TpmActivityContractConfig tpmActivityContractConfig = new TpmActivityContractConfig();
            tpmActivityContractConfig.setId(item.getId());
            tpmActivityContractConfig.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            activityContractConfigList.add(tpmActivityContractConfig);
            ActivityContractConfigLogEventDto logEventDto = new ActivityContractConfigLogEventDto();
            TpmActivityContractConfigVo oldVo = (TpmActivityContractConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldVo);
            TpmActivityContractConfigVo tpmActivityContractConfigVo = (TpmActivityContractConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmActivityContractConfigVo.setEnableStatus(tpmActivityContractConfig.getEnableStatus());
            logEventDto.setNewest(tpmActivityContractConfigVo);
            SerializableBiConsumer & Serializable onEnable = ActivityContractConfigEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityContractConfigEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.tpmActivityContractConfigRepository.updateBatchById(activityContractConfigList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List tpmActivityContractConfigList = this.tpmActivityContractConfigRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)tpmActivityContractConfigList) ? 1 : 0) != 0, (String)"\u7981\u7528\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList activityContractConfigList = new ArrayList();
        tpmActivityContractConfigList.forEach(item -> {
            TpmActivityContractConfig tpmActivityContractConfig = new TpmActivityContractConfig();
            tpmActivityContractConfig.setId(item.getId());
            tpmActivityContractConfig.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            activityContractConfigList.add(tpmActivityContractConfig);
            ActivityContractConfigLogEventDto logEventDto = new ActivityContractConfigLogEventDto();
            TpmActivityContractConfigVo oldVo = (TpmActivityContractConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldVo);
            TpmActivityContractConfigVo tpmActivityContractConfigVo = (TpmActivityContractConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmActivityContractConfigVo.setEnableStatus(tpmActivityContractConfig.getEnableStatus());
            logEventDto.setNewest(tpmActivityContractConfigVo);
            SerializableBiConsumer & Serializable onDisable = ActivityContractConfigEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityContractConfigEventListener.class, (SerializableBiConsumer)onDisable);
        });
        this.tpmActivityContractConfigRepository.updateBatchById(activityContractConfigList);
    }

    public List<TpmActivityContractConfigVo> listByConditions(TpmActivityContractConfigDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            return Lists.newArrayList();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessFormatCode()) || StringUtils.isEmpty((CharSequence)dto.getOrgCode())) {
            return Lists.newArrayList();
        }
        ArrayList<String> orgCodeList = new ArrayList<String>();
        orgCodeList.add(dto.getOrgCode());
        List allParent = this.orgVoService.findAllParentByOrgCode(dto.getOrgCode());
        if (!CollectionUtils.isEmpty((Collection)allParent)) {
            orgCodeList.addAll(allParent.stream().map(OrgVo::getOrgCode).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        dto.setOrgCodeList(orgCodeList);
        dto.setQueryTime(DateUtil.getDate((SimpleDateFormat)DateUtil.date_yyyy_MM_dd_HH_mm_ss));
        List<TpmActivityContractConfig> tpmActivityContractConfigs = this.tpmActivityContractConfigRepository.listByConditions(dto);
        if (CollectionUtils.isEmpty(tpmActivityContractConfigs)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(tpmActivityContractConfigs, TpmActivityContractConfig.class, TpmActivityContractConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<TpmActivityContractConfigVo> findByOrgCodeAndDate(String orgCode, String currentTime) {
        Validate.notBlank((CharSequence)orgCode, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)currentTime, (String)"\u5f53\u524d\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.tpmActivityContractConfigRepository.findByOrgCodeAndDate(orgCode, currentTime);
    }

    private void createValidate(TpmActivityContractConfigDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getContractWay(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u627f\u63a5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Date startTime = dto.getStartTime();
        Validate.notNull((Object)startTime, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u9009\u62e9\uff01", (Object[])new Object[0]);
        Date endTime = dto.getEndTime();
        Validate.notNull((Object)endTime, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u9009\u62e9\uff01", (Object[])new Object[0]);
        Validate.isTrue((!startTime.after(endTime) ? 1 : 0) != 0, (String)"\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5728\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e4b\u540e\uff01", (Object[])new Object[0]);
        List tpmActivityContractCompanyDtoList = dto.getTpmActivityContractCompanyDtoList();
        if (CollectionUtils.isEmpty((Collection)tpmActivityContractCompanyDtoList)) {
            throw new RuntimeException("\u8bf7\u81f3\u5c11\u9009\u4e00\u4e2a\u516c\u53f8\u7ef4\u62a4");
        }
        LinkedList<String> list = new LinkedList<String>();
        for (TpmActivityContractCompanyDto tpmActivityContractCompanyDto : tpmActivityContractCompanyDtoList) {
            Validate.notNull((Object)tpmActivityContractCompanyDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String orgCode = tpmActivityContractCompanyDto.getOrgCode();
            Validate.notBlank((CharSequence)orgCode, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((!list.contains(orgCode) ? 1 : 0) != 0, (String)"\u8bf7\u4e0d\u8981\u91cd\u590d\u9009\u62e9\u76f8\u540c\u7684\u7ec4\u7ec7\uff01", (Object[])new Object[0]);
            list.add(orgCode);
            Validate.notBlank((CharSequence)tpmActivityContractCompanyDto.getOrgName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)tpmActivityContractCompanyDto.getSalesOrgCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5206\u5b50\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)tpmActivityContractCompanyDto.getSalesOrgName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5206\u5b50\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
    }

    private void updateValidate(TpmActivityContractConfigDto dto) {
        Validate.notNull((Object)dto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getContractWay(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u627f\u63a5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Date startTime = dto.getStartTime();
        Validate.notNull((Object)startTime, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u9009\u62e9\uff01", (Object[])new Object[0]);
        Date endTime = dto.getEndTime();
        Validate.notNull((Object)endTime, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u9009\u62e9\uff01", (Object[])new Object[0]);
        Validate.isTrue((!startTime.after(endTime) ? 1 : 0) != 0, (String)"\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5728\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e4b\u540e\uff01", (Object[])new Object[0]);
        List tpmActivityContractCompanyDtoList = dto.getTpmActivityContractCompanyDtoList();
        if (CollectionUtils.isEmpty((Collection)tpmActivityContractCompanyDtoList)) {
            throw new RuntimeException("\u8bf7\u81f3\u5c11\u9009\u4e00\u4e2a\u516c\u53f8\u7ef4\u62a4");
        }
        LinkedList<String> list = new LinkedList<String>();
        for (TpmActivityContractCompanyDto tpmActivityContractCompanyDto : tpmActivityContractCompanyDtoList) {
            Validate.notNull((Object)tpmActivityContractCompanyDto, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String orgCode = tpmActivityContractCompanyDto.getOrgCode();
            Validate.notBlank((CharSequence)orgCode, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((!list.contains(orgCode) ? 1 : 0) != 0, (String)"\u8bf7\u4e0d\u8981\u91cd\u590d\u9009\u62e9\u76f8\u540c\u7684\u7ec4\u7ec7\uff01", (Object[])new Object[0]);
            list.add(orgCode);
            Validate.notBlank((CharSequence)tpmActivityContractCompanyDto.getOrgName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)tpmActivityContractCompanyDto.getSalesOrgCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5206\u5b50\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)tpmActivityContractCompanyDto.getSalesOrgName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5206\u5b50\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
    }
}

