package com.biz.crm.tpm.business.activity.contract.config.sdk.dto;


import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import org.springframework.format.annotation.DateTimeFormat;


import java.util.Date;
import java.util.List;


/**
 * @author heding
 * @create 2022/11/22 17:21:44
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "活动承接配置记录dto")
public class TpmActivityConfigRecordDto extends TenantFlagOpDto {


    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 有效开始时间
     */
    @ApiModelProperty(name = "有效开始时间", notes = "有效开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 有效结束时间
     */
    @ApiModelProperty(name = "有效结束时间", notes = "有效结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;
    /**
     * 承接方式
     */
    @ApiModelProperty(name = "承接方式", notes = "承接方式")
    private String contractWay;

    /**
     * 版本
     */
    @ApiModelProperty(name = "版本", notes = "版本")
    private Integer version;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码",notes = "组织编码")
    private String orgCode;
    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称",notes = "组织名称")
    private String orgName;
    /**
     * 分子公司编码
     */
    @ApiModelProperty(name = "分子公司编码",notes = "分子公司编码")
    private String salesOrgCode;
    /**
     * 分子公司名称
     */
    @ApiModelProperty(name = "分子公司名称",notes = "分子公司名称")
    private String salesOrgName;
    /**
     * 活动主键
     */
    @ApiModelProperty(name = "活动主键", notes = "活动主键")
    private String activityId;

}