package com.biz.crm.tpm.business.activity.contract.config.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年12月27日 11:33
 */
@Getter
public enum UndertakingFieldEnum {

    ASSOCIATION_TYPE("associationType", "关联类型"),
    ASSOCIATED_DATE_CODE("associatedDateCode", "关联数据编码"),
    UNDERTAKING_MODE("undertakingMode", "承接方式");

    private String field;

    private String title;

    UndertakingFieldEnum(String field, String title) {
        this.field = field;
        this.title = title;
    }

    /**
     * 转换为对应list
     *
     * @return java.util.Map<java.lang.String, java.lang.String>
     * @author huojia
     * @date 2022/10/26 20:17
     **/
    public static List<String> concertEnumToList() {
        List<String> list = new ArrayList<>();
        for (UndertakingFieldEnum t : UndertakingFieldEnum.values()) {
            list.add(t.getField());
        }
        return list;
    }

}
