package com.biz.crm.tpm.business.activity.contract.config.sdk.event.log;

import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.log.ActivityContractConfigLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author ：heding
 * @date ：Created in 2022/11/21 15:48
 * @description：活动承接配置日志接口
 */
public interface ActivityContractConfigEventListener extends NebulaEvent {
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreate(ActivityContractConfigLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDelete(ActivityContractConfigLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdate(ActivityContractConfigLogEventDto eventDto);
    /**
     * 启用
     *
     * @param eventDto
     */
    void onEnable(ActivityContractConfigLogEventDto eventDto);
    /**
     * 禁用
     *
     * @param eventDto
     */
    void onDisable(ActivityContractConfigLogEventDto eventDto);
}
