package com.biz.crm.tpm.business.activity.contract.config.sdk.service;


import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityConfigRecordDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityConfigRecordVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;


/**
 * 活动承接配置记录(TpmActivityConfigRecord)表服务接口
 *
 * @author heding
 * @create 2022/11/22 17:29:44
 */
public interface TpmActivityConfigRecordService {

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    Page<TpmActivityConfigRecordVo> findByConditions(Pageable pageable, TpmActivityConfigRecordDto dto);

    /**
     * 条件查询数据
     *
     * @param orgCode     组织编码
     * @param currentTime 当前时间
     * @return 结果
     */
    Boolean findByOrgCodeAndDate(String orgCode, String currentTime);

    /**
     * 保存历史配置
     *
     * @param record
     */
    void saveData(TpmActivityConfigRecordDto record);

}
