package com.biz.crm.tpm.business.activity.contract.config.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.contract.config.sdk.dto.TpmActivityContractConfigDto;
import com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractConfigVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 活动承接配置(TpmActivityContractConfig)表服务接口
 *
 * @author heding
 * @create 2022/11/22 17:29:44
 */
public interface TpmActivityContractConfigService {
    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    TpmActivityContractConfigVo findById(String id);

    /**
     * 删除数据
     *
     * @param idList 主键集合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    void create(TpmActivityContractConfigDto dto);

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    Page<TpmActivityContractConfigVo> findByConditions(Pageable pageable, TpmActivityContractConfigDto dto);

    /**
     * 编辑数据
     *
     * @param dto 实体对象
     * @return 编辑结果
     */
    void update(TpmActivityContractConfigDto dto);

    /**
     * 启用
     *
     * @param idList 主键集合
     * @return 启用结果
     */
    void enable(List<String> idList);

    /**
     * 禁用
     *
     * @param idList 主键集合
     * @return 禁用结果
     */
    void disable(List<String> idList);

    /**
     * 条件查询
     *
     * @param tpmActivityContractConfigDto
     * @return java.util.List<com.biz.crm.tpm.business.activity.contract.config.sdk.vo.TpmActivityContractConfigVo>
     * @author huojia
     * @date 2022/12/27 14:26
     **/
    List<TpmActivityContractConfigVo> listByConditions(TpmActivityContractConfigDto tpmActivityContractConfigDto);

    /**
     * 条件查询数据
     *
     * @param orgCode
     * @param currentTime
     * @return
     */
    List<TpmActivityContractConfigVo> findByOrgCodeAndDate(String orgCode, String currentTime);
}
