package com.biz.crm.tpm.business.activity.contract.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.contract.feign.feign.impl.ActivityContractFeignImpl;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractCodeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractDto;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractFormulaVariableVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/1/6 15:26
 * @description: 活动管理feign
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = ActivityContractFeignImpl.class)
public interface ActivityContractFeign {

    /**
     * 分页查询所有数据
     *
     * @param pageable            分页对象
     * @param activityContractDto 查询dto
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/v1/activityContract/findByConditions")
    Result<Page<ActivityContractVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                      @ApiParam(name = "activityContractDto", value = "活动合同主表Dto")@SpringQueryMap ActivityContractDto activityContractDto);


    /**
     * 获取合同公式变量
     *
     * @return 列表数据
     */
    @ApiOperation(value = "获取合同公式变量")
    @GetMapping("/v1/activityContract/getFormulaVariable")
    Result<List<ActivityContractFormulaVariableVo>> getFormulaVariable();

    /**
     * 根据适应范围编码获取合同基本信息
     *
     * @param dto 编码参数dto
     * @return 列表数据
     */
    @ApiOperation(value = "根据适应范围编码获取合同基本信息")
    @PostMapping("/v1/activityContract/getContractByScope")
    Result<List<ActivityContractVo>> getContractByScope(@RequestBody ActivityContractCodeDto dto);

    /**
     * 合同生成方案获取合同数据
     * @return
     */
    @GetMapping("/v1/activityContract/getContractForActivityPlan")
    Result<List<ActivityContractVo>> getContractForActivityPlan();

    @ApiOperation(value = "根据编码集合查询合同数据")
    @PostMapping("/v1/activityContract/findByCodeList")
    Result<List<ActivityContractVo>> findByCodeList(@RequestBody List<String> codeList);

}
