package com.biz.crm.tpm.business.activity.contract.feign.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.contract.feign.feign.ActivityContractFeign;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.*;
import com.biz.crm.tpm.business.activity.contract.sdk.service.ActivityContractSdkService;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractFormulaVariableVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractMaterialVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/1/6 15:24
 * @description:
 */
@Service("activityContractSdkService")
public class ActivityContractSdkServiceImpl implements ActivityContractSdkService {

    @Autowired(required = false)
    private ActivityContractFeign activityContractFeign;

    /**
     * 分页查询数据
     *
     * @param pageable            分页对象
     * @param activityContractDto 查询dto
     * @return Page<ActivityContractVo>
     */
    @Override
    public Page<ActivityContractVo> findByConditions(Pageable pageable, ActivityContractDto activityContractDto) {
        Result<Page<ActivityContractVo>> result = activityContractFeign.findByConditions(pageable, activityContractDto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public List<ActivityContractVo> findByCodeList(List<String> codeList) {
        Result<List<ActivityContractVo>> result = activityContractFeign.findByCodeList(codeList);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 保存第三方推送合同数据(单个)
     *
     * @param thirdDto 合同数据
     */
    @Override
    public void saveThirdSystemContractAndLog(ActivityContractThirdDto thirdDto) {
        throw new UnsupportedOperationException();
    }

    /**
     * 保存第三方推送合同数据(批量)
     *
     * @param list 合同数据列表
     */
    @Override
    public void saveThirdSystemContractBatchAndLog(List<ActivityContractThirdDto> list) {
        throw new UnsupportedOperationException();
    }

    /**
     * 获取合同公式变量
     *
     * @return 列表数据
     */
    @Override
    public List<ActivityContractFormulaVariableVo> getFormulaVariable() {
        Result<List<ActivityContractFormulaVariableVo>> result = activityContractFeign.getFormulaVariable();
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据适应范围编码获取合同基本信息
     *
     * @param dto 编码参数dto
     * @return 列表数据
     */
    @Override
    public List<ActivityContractVo> getContractByScope(ActivityContractCodeDto dto) {
        Result<List<ActivityContractVo>> result = activityContractFeign.getContractByScope(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public List<ActivityContractVo> getContractByKmsParams(ActivityContractCodeDto dto) {
        return null;
    }

    @Override
    public List<ActivityContractVo> getContractForActivityPlan() {
        Result<List<ActivityContractVo>> result = activityContractFeign.getContractForActivityPlan();
        Validate.isTrue(result.isSuccess(),result.getMessage());
        return result.getResult();
    }

    /**
     * 合同平台同步数据定时任务(根据日期段同步，默认同步当天的数据，日期段间隔天数勿太长，防止同步的数据量过大)
     */
    @Override
    public void syncContractPlatformByDate(ContractPlatformSyncDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActivityContractMaterialVo getActivityContractMaterial(ActivityContractMaterialDto dto) {
        throw new UnsupportedOperationException();
    }
}
