/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractFeeService;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractService;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractCodeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractFeeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ContractPlatformSyncDto;
import com.biz.crm.tpm.business.activity.contract.sdk.service.ActivityContractSdkService;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractFeeVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractFormulaVariableVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractReconSelectDataVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/activityContract"})
@Api(tags={"\u6d3b\u52a8\u5408\u540c\u7ba1\u7406"})
public class ActivityContractController {
    private static final Logger log = LoggerFactory.getLogger(ActivityContractController.class);
    @Autowired(required=false)
    private ActivityContractSdkService activityContractSdkService;
    @Autowired(required=false)
    private ActivityContractService activityContractService;
    @Autowired(required=false)
    private ActivityContractFeeService activityContractFeeService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ActivityContractVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityContractDto", value="\u6d3b\u52a8\u5408\u540c\u4e3b\u8868Dto") ActivityContractDto activityContractDto) {
        try {
            Page page = this.activityContractSdkService.findByConditions(pageable, activityContractDto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u96c6\u5408\u67e5\u8be2")
    @GetMapping(value={"findByCodeList"})
    public Result<List<ActivityContractVo>> findByCodeList(@RequestBody List<String> codeList) {
        try {
            List page = this.activityContractSdkService.findByCodeList(codeList);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5408\u540c\u7f16\u7801\u67e5\u8be2\u6263\u8d39\u660e\u7ec6")
    @GetMapping(value={"findFeeByCode"})
    public Result<List<ActivityContractFeeVo>> findFeeByCode(@RequestBody ActivityContractFeeDto dto) {
        try {
            return Result.ok(this.activityContractFeeService.findFeeByCode(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<ActivityContractVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            ActivityContractVo activityContractVo = this.activityContractService.findById(id);
            return Result.ok((Object)activityContractVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<?> create(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="activityContractDto", value="\u6d3b\u52a8\u5408\u540c\u4e3b\u8868Dto") @RequestBody ActivityContractDto activityContractDto) {
        try {
            this.activityContractService.create(activityContractDto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<?> update(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="activityContractDto", value="\u6d3b\u52a8\u5408\u540c\u4e3b\u8868Dto") @RequestBody ActivityContractDto activityContractDto) {
        try {
            this.activityContractService.update(cacheKey, activityContractDto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u786e\u8ba4\u5408\u540c")
    @GetMapping(value={"confirmById/{id}"})
    public Result<?> confirmById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            this.activityContractService.confirmById(id);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5408\u540c\u516c\u5f0f\u53d8\u91cf")
    @GetMapping(value={"getFormulaVariable"})
    public Result<List<ActivityContractFormulaVariableVo>> getFormulaVariable() {
        try {
            List list = this.activityContractSdkService.getFormulaVariable();
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9002\u5e94\u8303\u56f4\u7f16\u7801\u83b7\u53d6\u5408\u540c\u57fa\u672c\u4fe1\u606f")
    @PostMapping(value={"getContractByScope"})
    public Result<List<ActivityContractVo>> getContractByScope(@RequestBody ActivityContractCodeDto dto) {
        try {
            List list = this.activityContractSdkService.getContractByScope(dto);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u751f\u6210\u65b9\u6848\u83b7\u53d6\u5408\u540c\u6570\u636e")
    @GetMapping(value={"getContractForActivityPlan"})
    public Result<List<ActivityContractVo>> getContractForActivityPlan() {
        try {
            return Result.ok((Object)this.activityContractSdkService.getContractForActivityPlan());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5bf9\u8d26\u65e5\u671f\u914d\u7f6e\u4e0b\u62c9\u6570\u636e")
    @GetMapping(value={"getContractReconSelectData"})
    public Result<ActivityContractReconSelectDataVo> getContractReconSelectData(@RequestParam(value="reconPeriod") String reconPeriod) {
        try {
            return Result.ok((Object)this.activityContractService.getContractReconSelectData(reconPeriod));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5408\u540c\u5e73\u53f0\u540c\u6b65\u6570\u636e\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"syncContractPlatformByDate"})
    public void syncContractPlatformByDate() {
        try {
            log.info("\u5408\u540c\u5e73\u53f0\u540c\u6b65\u6570\u636e\u5f00\u59cb\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
            ContractPlatformSyncDto dto = new ContractPlatformSyncDto();
            this.activityContractSdkService.syncContractPlatformByDate(dto);
            log.info("\u5408\u540c\u5e73\u53f0\u540c\u6b65\u6570\u636e\u7ed3\u675f\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="\u624b\u52a8\u8c03\u7528\u5408\u540c\u5e73\u53f0\u540c\u6b65\u6570\u636e\u5b9a\u65f6\u4efb\u52a1(\u6839\u636e\u65e5\u671f\u6bb5\u540c\u6b65\uff0c\u9ed8\u8ba4\u540c\u6b65\u5f53\u5929\u7684\u6570\u636e\uff0c\u65e5\u671f\u6bb5\u95f4\u9694\u5929\u6570\u52ff\u592a\u957f\uff0c\u9632\u6b62\u540c\u6b65\u7684\u6570\u636e\u91cf\u8fc7\u5927)")
    @PostMapping(value={"manualSyncContractPlatformByDate"})
    public Result<?> manualSyncContractPlatformByDate(@RequestBody ContractPlatformSyncDto dto) {
        try {
            this.activityContractSdkService.syncContractPlatformByDate(dto);
            return Result.ok((String)"\u5408\u540c\u540c\u6b65\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

