/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.tpm.business.activity.contract.local.imports.vo.ActivityContractFeeImportVo;
import com.biz.crm.tpm.business.activity.contract.local.service.helper.ActivityContractFeePageCacheHelper;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractFeeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractScopeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractVariableEventDto;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractScopeTypeEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.event.ActivityContractVariableEventListener;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivtiyContractVariableResponse;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityContractFeeImportProcess
implements ImportProcess<ActivityContractFeeImportVo> {
    private static final Logger log = LoggerFactory.getLogger(ActivityContractFeeImportProcess.class);
    @Autowired(required=false)
    private ActivityContractFeePageCacheHelper activityContractFeePageCacheHelper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private YearBudgetSdkService yearBudgetSdkService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private AuditFormulaMainService auditFormulaMainService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    private static final Pattern PATTERN_CHINESE = Pattern.compile("[0-9]*[\\u4e00-\\u9fa5\\w]{1,}[0-9]*");

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityContractFeeImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        log.error("\u7b2c0\u6b65\u83b7\u53d6params={}", params);
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object businessFormatCode = params.get("businessFormatCode");
        Validate.notNull((Object)businessFormatCode, (String)"\u4e1a\u6001businessFormatCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object businessUnitCode = params.get("businessUnitCode");
        Validate.notNull((Object)businessFormatCode, (String)"\u4e1a\u52a1\u5355\u5143businessUnitCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtil.isEmpty(data)) {
            return null;
        }
        try {
            List auditFormulaList;
            List itemVos;
            List formVos;
            List typeVos;
            List terminalVoList;
            ArrayList importVos = Lists.newArrayList(data.values());
            Map dimensionMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_contract_fee_dimension");
            Map typeMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_contract_fee_type");
            Map storeMap = this.dictToolkitService.findConvertMapByDictTypeCode("ac_store_type");
            HashSet<String> actTypeCodes = new HashSet<String>();
            HashSet<String> formCodes = new HashSet<String>();
            HashSet<String> budgetItemCodes = new HashSet<String>();
            HashSet budgetMonthCodes = new HashSet();
            HashSet<String> auditFormulaCodeSet = new HashSet<String>();
            for (ActivityContractFeeImportVo importVo : importVos) {
                Validate.notBlank((CharSequence)importVo.getFeeName(), (String)"\u6263\u8d39\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)importVo.getIsAutoApply(), (String)"\u662f\u5426\u81ea\u52a8\u751f\u6210\u7533\u8bf7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                if (BooleanEnum.TRUE.getSure().equals(importVo.getIsAutoApply())) {
                    Validate.notBlank((CharSequence)importVo.getActivityFormCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                } else {
                    Validate.isTrue((boolean)BooleanEnum.FALSE.getSure().equals(importVo.getIsAutoApply()), (String)"\u662f\u5426\u81ea\u52a8\u751f\u6210\u7533\u8bf7\u65e0\u6cd5\u8bc6\u522b[%s]", (Object[])new Object[]{importVo.getIsAutoApply()});
                }
                Validate.notBlank((CharSequence)importVo.getFeeDimension(), (String)"\u6263\u8d39\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)importVo.getFeeType(), (String)"\u6263\u8d39\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                if (StringUtils.isNotBlank((CharSequence)importVo.getActivityFormCode())) {
                    formCodes.add(importVo.getActivityFormCode());
                }
                if (StringUtils.isNotBlank((CharSequence)importVo.getActivityTypeCode())) {
                    actTypeCodes.add(importVo.getActivityTypeCode());
                }
                if (StringUtils.isNotBlank((CharSequence)importVo.getBudgetProjectCode())) {
                    budgetItemCodes.add(importVo.getBudgetProjectCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getAuditConditionCode())) {
                    auditFormulaCodeSet.add(importVo.getAuditConditionCode());
                }
                String[] dimens = importVo.getFeeDimension().split(",");
                ArrayList dimenList = new ArrayList();
                for (String s : dimens) {
                    Validate.isTrue((boolean)dimensionMap.containsKey(s), (String)"\u6263\u8d39\u7ef4\u5ea6[%s]\u672a\u80fd\u8bc6\u522b", (Object[])new Object[]{s});
                    dimenList.add(dimensionMap.get(s));
                }
                importVo.setFeeDimensionList(dimenList);
                Validate.isTrue((boolean)typeMap.containsKey(importVo.getFeeType()), (String)"\u6263\u8d39\u7c7b\u578b[%s]\u672a\u80fd\u8bc6\u522b", (Object[])new Object[]{importVo.getFeeType()});
                importVo.setFeeType((String)typeMap.get(importVo.getFeeType()));
            }
            HashSet<String> storesContainsCodeSet = new HashSet<String>();
            Map terminalVoMap = null;
            List storesContainsCodes = importVos.stream().map(ActivityContractFeeImportVo::getStoresContains).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            for (Object stores : storesContainsCodes) {
                String[] split;
                for (String s : split = ((String)stores).split(",")) {
                    storesContainsCodeSet.add(s);
                }
            }
            List storesNotContainsCodes = importVos.stream().map(ActivityContractFeeImportVo::getStoresNotContains).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            for (String storesNot : storesNotContainsCodes) {
                String[] split;
                for (String s : split = storesNot.split(",")) {
                    storesContainsCodeSet.add(s);
                }
            }
            if (!CollectionUtils.isEmpty(storesContainsCodeSet) && !CollectionUtil.isEmpty((Collection)(terminalVoList = this.terminalVoService.findDetailsByTerminalCodesPOST((List)Lists.newArrayList(storesContainsCodeSet))))) {
                terminalVoMap = terminalVoList.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (v1, v2) -> v2));
            }
            Map<Object, Object> actTypeMap = new HashMap();
            if (!actTypeCodes.isEmpty() && !CollectionUtil.isEmpty((Collection)(typeVos = this.activityTypeService.findByCodes(new ArrayList(actTypeCodes))))) {
                actTypeMap = typeVos.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, ActivityTypeVo::getActivityTypeName, (oldValue, newValue) -> newValue));
            }
            Map<Object, Object> formMap = new HashMap();
            if (!formCodes.isEmpty() && !CollectionUtil.isEmpty((Collection)(formVos = this.activityFormService.findActivityFormByCode(formCodes)))) {
                formMap = formVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, ActivityFormVo::getActivityFormName, (oldValue, newValue) -> newValue));
            }
            Map<Object, Object> budgetItemMap = new HashMap();
            if (!budgetItemCodes.isEmpty() && !CollectionUtil.isEmpty((Collection)(itemVos = this.budgetItemService.listByCodes(new ArrayList(budgetItemCodes))))) {
                budgetItemMap = itemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, BudgetItemVo::getBudgetItemName, (oldValue, newValue) -> newValue));
            }
            Map<Object, Object> auditFormulaMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(auditFormulaCodeSet) && !CollectionUtils.isEmpty((Collection)(auditFormulaList = this.auditFormulaMainService.findByCodeList((List)Lists.newArrayList(auditFormulaCodeSet))))) {
                auditFormulaMap = auditFormulaList.stream().collect(Collectors.toMap(AuditFormulaMainVo::getAuditFormulaCode, Function.identity(), (o, n) -> n));
            }
            ActivityContractVariableEventDto eventDto = new ActivityContractVariableEventDto();
            eventDto.setIsConfigure(BooleanEnum.FALSE.getNumStr());
            SerializableBiConsumer & Serializable getContractVariable = ActivityContractVariableEventListener::getContractVariable;
            EventResponse eventResponse = this.nebulaNetEventClient.directPublish((NebulaEventDto)eventDto, ActivityContractVariableEventListener.class, (SerializableBiConsumer)getContractVariable);
            Validate.notNull((Object)eventResponse, (String)"\u83b7\u53d6\u5408\u540c\u53d8\u91cf\uff0c\u4e8b\u4ef6\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
            ActivtiyContractVariableResponse variableResponse = (ActivtiyContractVariableResponse)eventResponse;
            Map varMap = new HashMap();
            if (!variableResponse.getVarMap().isEmpty()) {
                varMap = variableResponse.getVarMap();
            }
            ArrayList<ActivityContractFeeDto> dtoList = new ArrayList<ActivityContractFeeDto>();
            for (ActivityContractFeeImportVo importVo : importVos) {
                if (StringUtils.isNotBlank((CharSequence)importVo.getActivityFormCode())) {
                    Validate.isTrue((boolean)formMap.containsKey(importVo.getActivityFormCode()), (String)"\u672a\u67e5\u627e\u5230\u6b64\u6d3b\u52a8\u5f62\u5f0f[%s]", (Object[])new Object[]{importVo.getActivityFormCode()});
                    importVo.setActivityFormName((String)formMap.get(importVo.getActivityFormCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)importVo.getActivityTypeCode())) {
                    Validate.isTrue((boolean)actTypeMap.containsKey(importVo.getActivityTypeCode()), (String)"\u672a\u67e5\u627e\u5230\u6b64\u6d3b\u52a8\u5206\u7c7b[%s]", (Object[])new Object[]{importVo.getActivityTypeCode()});
                    importVo.setActivityTypeName((String)actTypeMap.get(importVo.getActivityTypeCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)importVo.getBudgetProjectCode())) {
                    Validate.isTrue((boolean)budgetItemMap.containsKey(importVo.getBudgetProjectCode()), (String)"\u672a\u67e5\u627e\u5230\u6b64\u9884\u7b97\u9879\u76ee[%s]", (Object[])new Object[]{importVo.getBudgetProjectCode()});
                    importVo.setBudgetProjectName((String)budgetItemMap.get(importVo.getBudgetProjectCode()));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getAuditConditionCode())) {
                    AuditFormulaMainVo auditFormula = (AuditFormulaMainVo)auditFormulaMap.get(importVo.getAuditConditionCode());
                    if (Objects.isNull(auditFormula)) {
                        throw new RuntimeException("\u6838\u9500\u6761\u4ef6[" + importVo.getAuditConditionCode() + "]\u6709\u8bef");
                    }
                    importVo.setAuditConditionName(auditFormula.getAuditFormulaName());
                }
                ActivityContractFeeDto dto = (ActivityContractFeeDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)importVo, ActivityContractFeeDto.class, HashSet.class, ArrayList.class, new String[0]);
                dto.setFeeDimensionList(importVo.getFeeDimensionList());
                ArrayList<ActivityContractScopeDto> storesContainsList = new ArrayList<ActivityContractScopeDto>();
                HashSet<String> storesContainsStrSet = new HashSet<String>();
                if (!StringUtils.isBlank((CharSequence)importVo.getStoresContains())) {
                    String[] split;
                    for (String storesCode : split = importVo.getStoresContains().split(",")) {
                        TerminalVo terminalVo;
                        if (CollectionUtil.isEmpty(terminalVoMap) || Objects.isNull(terminalVo = (TerminalVo)terminalVoMap.get(storesCode))) continue;
                        ActivityContractScopeDto terminalScopeDto = new ActivityContractScopeDto();
                        terminalScopeDto.setScopeType(ContractScopeTypeEnum.STORES.getCode());
                        terminalScopeDto.setScopeContains(BooleanEnum.TRUE.getCapital());
                        terminalScopeDto.setScopeCode(terminalVo.getTerminalCode());
                        terminalScopeDto.setScopeName(terminalVo.getTerminalName());
                        terminalScopeDto.setTerminalCode(terminalVo.getTerminalCode());
                        terminalScopeDto.setTerminalName(terminalVo.getTerminalName());
                        storesContainsStrSet.add(terminalVo.getTerminalName());
                        storesContainsList.add(terminalScopeDto);
                    }
                }
                if (!CollectionUtils.isEmpty(storesContainsStrSet)) {
                    StringBuilder storesContainsStr = new StringBuilder();
                    Iterator iteratorIt = storesContainsStrSet.iterator();
                    while (iteratorIt.hasNext()) {
                        String next = (String)iteratorIt.next();
                        storesContainsStr.append(next);
                        if (!iteratorIt.hasNext()) continue;
                        storesContainsStr.append(",");
                    }
                    dto.setStoresContainsListStr(storesContainsStr.toString());
                }
                ArrayList<ActivityContractScopeDto> storesNotContainsList = new ArrayList<ActivityContractScopeDto>();
                HashSet<String> storesNotContainsStrSet = new HashSet<String>();
                if (!StringUtils.isBlank((CharSequence)importVo.getStoresNotContains())) {
                    String[] split;
                    for (String storesNotCode : split = importVo.getStoresNotContains().split(",")) {
                        TerminalVo terminalVo;
                        if (CollectionUtil.isEmpty(terminalVoMap) || Objects.isNull(terminalVo = (TerminalVo)terminalVoMap.get(storesNotCode))) continue;
                        ActivityContractScopeDto terminalNotScopeDto = new ActivityContractScopeDto();
                        terminalNotScopeDto.setScopeType(ContractScopeTypeEnum.STORES.getCode());
                        terminalNotScopeDto.setScopeContains(BooleanEnum.FALSE.getCapital());
                        terminalNotScopeDto.setScopeCode(terminalVo.getTerminalCode());
                        terminalNotScopeDto.setScopeName(terminalVo.getTerminalName());
                        terminalNotScopeDto.setTerminalCode(terminalVo.getTerminalCode());
                        terminalNotScopeDto.setTerminalName(terminalVo.getTerminalName());
                        storesNotContainsStrSet.add(terminalVo.getTerminalName());
                        storesNotContainsList.add(terminalNotScopeDto);
                    }
                }
                if (!CollectionUtils.isEmpty(storesNotContainsStrSet)) {
                    StringBuilder storesNotContainsStr = new StringBuilder();
                    Iterator iteratorNotIt = storesNotContainsStrSet.iterator();
                    while (iteratorNotIt.hasNext()) {
                        String next = (String)iteratorNotIt.next();
                        storesNotContainsStr.append(next);
                        if (!iteratorNotIt.hasNext()) continue;
                        storesNotContainsStr.append(",");
                    }
                    dto.setStoresNotContainsListStr(storesNotContainsStr.toString());
                }
                if (BooleanEnum.TRUE.getSure().equals(dto.getIsAutoApply())) {
                    dto.setIsAutoApply(BooleanEnum.TRUE.getCapital());
                }
                dto.setStoresContainsList(storesContainsList);
                dto.setStoresNotContainsList(storesNotContainsList);
                dtoList.add(dto);
            }
            this.activityContractFeePageCacheHelper.importNewItem((String)cacheKey, dtoList);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return null;
    }

    public Class<ActivityContractFeeImportVo> findCrmExcelVoClass() {
        return ActivityContractFeeImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_ACTIVITY_CONTRACT_ITEM_FEE_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5408\u540c\u6263\u8d39\u660e\u7ec6\u5bfc\u5165";
    }

    public String getBusinessCode() {
        return "TPM_ACTIVITY_CONTRACT_ITEM_FEE_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u5408\u540c\u6263\u8d39\u660e\u7ec6\u5bfc\u5165";
    }

    public Set<String> getFormulaReplace(String formula) {
        Matcher matcher = PATTERN_CHINESE.matcher(formula);
        HashSet<String> variables = new HashSet<String>();
        while (matcher.find()) {
            String group = matcher.group();
            if ("INT".equals(group) || "int".equals(group) || "and".equals(group)) continue;
            variables.add(group);
        }
        return variables;
    }

    private String replaceExpression(String expression, Set<String> variables, Map<String, String> variableValueMap) {
        for (String variable : variables) {
            String value = variableValueMap.get(variable);
            Validate.notNull((Object)value, (String)"\u8ba1\u7b97\u65f6\u68c0\u6d4b\u5230\u53d8\u91cf\u3010%s\u3011\u503c\u4e3a\u7a7a", (Object[])new Object[]{variable});
            expression = expression.replace(variable, value);
        }
        return expression;
    }
}

