/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.promotion.material.sdk.service.PromotionMaterialService;
import com.biz.crm.tpm.business.activity.contract.local.imports.vo.ActivityContractMaterialImportVo;
import com.biz.crm.tpm.business.activity.contract.local.service.helper.ActivityContractMaterialPageCacheHelper;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractMaterialDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityContractMaterialImportProcess
implements ImportProcess<ActivityContractMaterialImportVo> {
    private static final Logger log = LoggerFactory.getLogger(ActivityContractMaterialImportProcess.class);
    @Autowired(required=false)
    private ActivityContractMaterialPageCacheHelper activityContractMaterialPageCacheHelper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private PromotionMaterialService promotionMaterialService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, ActivityContractMaterialImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, ActivityContractMaterialImportVo> row : data.entrySet()) {
            String errInfo;
            int rowNum = row.getKey();
            ActivityContractMaterialImportVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getMaterialCode()), "\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getMaterialName()), "\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(vo.getMoney() != null, "\u7269\u6599\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
            boolean a = this.validateQuality(vo.getQualityOneStr(), vo);
            boolean b = this.validateQuality(vo.getQualityTwoStr(), vo);
            if (a) {
                vo.setQualityOne(new BigDecimal(vo.getQualityOneStr()));
            } else {
                this.validateIsTrue(a, "\u6570\u91cf1\u5fc5\u987b\u586b\u6570\u91cf\u7c7b\u578b\u6570\u636e");
            }
            if (b) {
                vo.setQualityTwo(new BigDecimal(vo.getQualityTwoStr()));
            } else {
                this.validateIsTrue(b, "\u6570\u91cf2\u5fc5\u987b\u586b\u6570\u91cf\u7c7b\u578b\u6570\u636e");
            }
            if ((errInfo = this.validateGetErrorInfo()) == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    private boolean validateQuality(String qualityStr, ActivityContractMaterialImportVo vo) {
        try {
            BigDecimal bigDecimal = new BigDecimal(qualityStr);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityContractMaterialImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        log.error("\u7b2c0\u6b65\u83b7\u53d6params={}", params);
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        log.error("\u7b2c\u4e00\u6b65\u83b7\u53d6cacheKey={}", cacheKey);
        if (CollectionUtil.isEmpty(data)) {
            return null;
        }
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        try {
            Map map = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_contract_material_compare");
            log.error("\u7b2c\u4e8c\u6b65\u83b7\u53d6\u7b26\u53f7\u5b57\u5178={}", (Object)map);
            HashSet<String> materialCodes = new HashSet<String>();
            for (ActivityContractMaterialImportVo activityContractMaterialImportVo : data.values()) {
                materialCodes.add(activityContractMaterialImportVo.getMaterialCode());
            }
            Map maMap = this.promotionMaterialService.findMaterialNameByCodes(new ArrayList(materialCodes));
            log.error("\u7b2c\u4e09\u6b65\u83b7\u53d6\u4fc3\u9500\u7269\u6599={}\uff0c\u7269\u6599\u7f16\u7801={}", (Object)maMap, materialCodes);
            for (Map.Entry<Integer, ActivityContractMaterialImportVo> entry : data.entrySet()) {
                ActivityContractMaterialImportVo importVo = entry.getValue();
                if (StringUtils.isNotBlank((CharSequence)importVo.getSymbolOne())) {
                    if (map.containsKey(importVo.getSymbolOne())) {
                        importVo.setSymbolOne((String)map.get(importVo.getSymbolOne()));
                    } else {
                        this.validateIsTrue(false, "\u7b26\u53f7\u65e0\u6cd5\u8bc6\u522b");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)importVo.getSymbolTwo())) {
                    if (map.containsKey(importVo.getSymbolTwo())) {
                        importVo.setSymbolTwo((String)map.get(importVo.getSymbolTwo()));
                    } else {
                        this.validateIsTrue(false, "\u7b26\u53f7\u65e0\u6cd5\u8bc6\u522b");
                    }
                }
                if (maMap.containsKey(importVo.getMaterialCode())) {
                    importVo.setMaterialName((String)maMap.get(importVo.getMaterialCode()));
                } else {
                    this.validateIsTrue(false, "\u672a\u67e5\u627e\u5230\u7269\u6599\u4fe1\u606f");
                }
                importVo.setQualityOne(new BigDecimal(importVo.getQualityOneStr()));
                importVo.setQualityTwo(new BigDecimal(importVo.getQualityTwoStr()));
                String errInfo = this.validateGetErrorInfo();
                if (errInfo == null) continue;
                errMap.put(entry.getKey(), errInfo);
            }
            if (errMap.isEmpty()) {
                Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), ActivityContractMaterialImportVo.class, ActivityContractMaterialDto.class, HashSet.class, ArrayList.class, new String[0]);
                log.error("\u7b2c\u56db\u6b65\u4fdd\u5b58\u7f13\u5b58\u6570\u636e={}", (Object)collection);
                this.activityContractMaterialPageCacheHelper.importNewItem((String)cacheKey, (List)collection);
                log.error("\u5b8c\u6210");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return errMap;
    }

    public Class<ActivityContractMaterialImportVo> findCrmExcelVoClass() {
        return ActivityContractMaterialImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_ACTIVITY_CONTRACT_ITEM_MATERIAL_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5408\u540c\u7269\u6599\u660e\u7ec6\u5bfc\u5165";
    }

    public String getBusinessCode() {
        return "TPM_ACTIVITY_CONTRACT_ITEM_MATERIAL_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u5408\u540c\u7269\u6599\u660e\u7ec6\u5bfc\u5165";
    }
}

