/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractFee;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractFeeDimension;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractScope;
import com.biz.crm.tpm.business.activity.contract.local.mapper.ActivityContractFeeMapper;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractFeeDimensionRepository;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractFeeFormulaRepository;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractScopeRepository;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractFeeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractScopeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractScopeTypeEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityContractFeeRepository
extends ServiceImpl<ActivityContractFeeMapper, ActivityContractFee> {
    @Autowired(required=false)
    private ActivityContractFeeMapper activityContractFeeMapper;
    @Autowired(required=false)
    private ActivityContractFeeFormulaRepository activityContractFeeFormulaRepository;
    @Autowired(required=false)
    private ActivityContractFeeDimensionRepository activityContractFeeDmensionRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityContractScopeRepository activityContractScopeRepository;

    public void updateBatchByIdAndTenantCode(Collection<ActivityContractFee> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getId())) {
                LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
                lambdaUpdateWrapper.eq(UuidEntity::getId, (Object)item.getId());
                ((ActivityContractFeeMapper)this.baseMapper).update(item, (Wrapper)lambdaUpdateWrapper);
            }
        });
    }

    public List<ActivityContractFeeDto> findDtoAndAttachListByContractNo(String contractNo) {
        ActivityContractFeeDto dto = new ActivityContractFeeDto();
        dto.setContractNo(contractNo);
        return this.findDtoAndAttachList(dto);
    }

    public List<ActivityContractFeeDto> findDtoAndAttachList(ActivityContractFeeDto dto) {
        List feeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityContractFee::getContractNo, (Object)dto.getContractNo())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (!CollectionUtils.isEmpty((Collection)feeList)) {
            Collection feeDtoList = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)feeList, ActivityContractFee.class, ActivityContractFeeDto.class, HashSet.class, ArrayList.class, new String[0]);
            List dimensionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractFeeDmensionRepository.lambdaQuery().eq(ActivityContractFeeDimension::getContractNo, (Object)dto.getContractNo())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
            Map<Object, Object> dimensionMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)dimensionList)) {
                dimensionMap = dimensionList.stream().collect(Collectors.groupingBy(ActivityContractFeeDimension::getContractFeeCode, Collectors.mapping(ActivityContractFeeDimension::getFeeDimensionCode, Collectors.toList())));
            }
            List contractFeeCodes = feeDtoList.stream().map(ActivityContractFeeDto::getContractFeeCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List storesList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractScopeRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(ActivityContractScope::getContractFeeCode, contractFeeCodes)).list();
            Map<String, List<ActivityContractScope>> storesMap = null;
            if (!CollectionUtils.isEmpty((Collection)storesList)) {
                storesMap = storesList.stream().collect(Collectors.groupingBy(ActivityContractScope::getContractFeeCode));
            }
            for (ActivityContractFeeDto feeDto : feeDtoList) {
                List<ActivityContractScope> stores;
                feeDto.setFeeDimensionList((List)dimensionMap.getOrDefault(feeDto.getContractFeeCode(), null));
                ArrayList stList = new ArrayList();
                ArrayList stNotList = new ArrayList();
                if (!CollectionUtils.isEmpty(storesMap) && !CollectionUtils.isEmpty(stores = storesMap.get(feeDto.getContractFeeCode()))) {
                    List stDtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(stores, ActivityContractScope.class, ActivityContractScopeDto.class, HashSet.class, ArrayList.class, new String[0]);
                    stDtoList.forEach(store -> {
                        if (!ContractScopeTypeEnum.STORES.getCode().equals(store.getScopeType())) {
                            return;
                        }
                        store.setTerminalCode(store.getScopeCode());
                        store.setTerminalName(store.getScopeName());
                        if (BooleanEnum.TRUE.getCapital().equals(store.getScopeContains())) {
                            stList.add(store);
                        }
                        if (BooleanEnum.FALSE.getCapital().equals(store.getScopeContains())) {
                            stNotList.add(store);
                        }
                    });
                }
                feeDto.setStoresContainsList(stList);
                feeDto.setStoresNotContainsList(stNotList);
            }
            return (List)feeDtoList;
        }
        return Lists.newArrayList();
    }
}

