/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.promotion.material.sdk.enums.PromotionMaterialEnum;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractMaterial;
import com.biz.crm.tpm.business.activity.contract.local.mapper.ActivityContractMaterialMapper;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractMaterialDto;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractMaterialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityContractMaterialRepository
extends ServiceImpl<ActivityContractMaterialMapper, ActivityContractMaterial> {
    @Autowired(required=false)
    private ActivityContractMaterialMapper activityContractMaterialMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public void updateBatchByIdAndTenantCode(Collection<ActivityContractMaterial> entitys, String tenantCode) {
        if (CollectionUtils.isEmpty(entitys)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantCode)) {
            return;
        }
        entitys.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getId())) {
                LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
                lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
                lambdaUpdateWrapper.eq(UuidEntity::getId, (Object)item.getId());
                ((ActivityContractMaterialMapper)this.baseMapper).update(item, (Wrapper)lambdaUpdateWrapper);
            }
        });
    }

    public List<ActivityContractMaterialDto> findDtoAndAttachListByContractNo(String contractNo) {
        ActivityContractMaterialDto dto = new ActivityContractMaterialDto();
        dto.setContractNo(contractNo);
        return this.findDtoAndAttachList(dto);
    }

    public List<ActivityContractMaterialDto> findDtoAndAttachList(ActivityContractMaterialDto dto) {
        List materialList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityContractMaterial::getContractNo, (Object)dto.getContractNo())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (!CollectionUtils.isEmpty((Collection)materialList)) {
            Collection materialDtoList = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)materialList, ActivityContractMaterial.class, ActivityContractMaterialDto.class, HashSet.class, ArrayList.class, new String[0]);
            return (List)materialDtoList;
        }
        return Lists.newArrayList();
    }

    public List<ActivityContractMaterialVo> findActivityContractMaterialList(ActivityContractMaterialDto dto) {
        List materialList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityContractMaterial::getContractNo, (Object)dto.getContractNo())).eq(ActivityContractMaterial::getMaterialCode, (Object)dto.getMaterialCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)materialList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)materialList, ActivityContractMaterial.class, ActivityContractMaterialVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public ActivityContractMaterialVo getActivityContractMaterial(ActivityContractMaterialDto dto) {
        List<ActivityContractMaterialVo> materialList = this.findActivityContractMaterialList(dto);
        if (CollectionUtils.isEmpty(materialList)) {
            return null;
        }
        BigDecimal quantity = dto.getMaterialQuantity();
        ActivityContractMaterialVo activityContractMaterial = materialList.stream().filter(level -> {
            if (null != level.getQualityOne()) {
                if (level.getQualityOne().compareTo(quantity) > 0) {
                    return false;
                }
                if (level.getQualityOne().compareTo(quantity) == 0 && PromotionMaterialEnum.Symbol.LessThanSign.getValue().equals(level.getSymbolOne())) {
                    return false;
                }
            }
            if (null != level.getQualityTwo()) {
                if (level.getQualityTwo().compareTo(quantity) < 0) {
                    return false;
                }
                if (level.getQualityOne().compareTo(quantity) == 0 && PromotionMaterialEnum.Symbol.LessThanSign.getValue().equals(level.getSymbolTwo())) {
                    return false;
                }
            }
            return true;
        }).findFirst().orElse(null);
        if (null == activityContractMaterial) {
            return null;
        }
        return activityContractMaterial;
    }
}

