/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContract;
import com.biz.crm.tpm.business.activity.contract.local.mapper.ActivityContractMapper;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractCodeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractDto;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityContractRepository
extends ServiceImpl<ActivityContractMapper, ActivityContract> {
    @Autowired(required=false)
    private ActivityContractMapper activityContractMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<ActivityContractVo> findByConditions(Pageable pageable, ActivityContractDto activityContractDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ActivityContractVo> pageList = this.activityContractMapper.findByConditions((Page<ActivityContractVo>)page, activityContractDto);
        return pageList;
    }

    public List<ActivityContract> getContractByScope(ActivityContractCodeDto dto) {
        return this.activityContractMapper.getContractByScope(dto);
    }

    public List<ActivityContractVo> getContractByKmsParams(ActivityContractCodeDto dto) {
        return this.activityContractMapper.getContractByKmsParams(dto);
    }

    public List<ActivityContractVo> findByCodeList(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityContract::getContractNo, codeList)).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ActivityContract.class, ActivityContractVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

