/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.service.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractFeeRepository;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractFeeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractFeeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityContractFeePageCacheHelper
extends MnPageCacheHelper<ActivityContractFeeVo, ActivityContractFeeDto> {
    @Autowired(required=false)
    private ActivityContractFeeRepository activityContractFeeRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public String getCacheKeyPrefix() {
        return "activity_contract_fee:item_cache:";
    }

    public Class<ActivityContractFeeDto> getDtoClass() {
        return ActivityContractFeeDto.class;
    }

    public Class<ActivityContractFeeVo> getVoClass() {
        return ActivityContractFeeVo.class;
    }

    public List<ActivityContractFeeDto> findDtoListFromRepository(ActivityContractFeeDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getContractNo())) {
            return Lists.newArrayList();
        }
        List<ActivityContractFeeDto> dtoList = this.activityContractFeeRepository.findDtoAndAttachListByContractNo(dto.getContractNo());
        dtoList.sort(Comparator.comparing(ActivityContractFeeDto::getContractFeeCode));
        return dtoList;
    }

    public List<ActivityContractFeeDto> newItem(String cacheKey, List<ActivityContractFeeDto> itemList) {
        ActivityContractFeeDto newItem = new ActivityContractFeeDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return Lists.newArrayList((Object[])new ActivityContractFeeDto[]{newItem});
    }

    public List<ActivityContractFeeDto> copyItem(String cacheKey, List<ActivityContractFeeDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityContractFeeDto.class, ActivityContractFeeDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (ActivityContractFeeDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setContractFeeCode(null);
        }
        return newItemList;
    }

    public void updateItem(String cacheKey, List<ActivityContractFeeDto> itemList) {
    }

    public Object getDtoKey(ActivityContractFeeDto activityContractFeeDto) {
        return activityContractFeeDto.getId();
    }

    public String getCheckedStatus(ActivityContractFeeDto activityContractFeeDto) {
        return activityContractFeeDto.getChecked();
    }

    public void importNewItem(String cacheKey, List<ActivityContractFeeDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        for (ActivityContractFeeDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTenantCode(TenantUtils.getTenantCode());
        }
        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        Map updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    public List<ActivityContractFeeVo> dtoListToVoList(List<ActivityContractFeeDto> dtoList) {
        ArrayList<ActivityContractFeeVo> list = new ArrayList<ActivityContractFeeVo>();
        if (CollectionUtils.isEmpty(dtoList)) {
            return list;
        }
        for (ActivityContractFeeDto feeDto : dtoList) {
            ActivityContractFeeVo feeVo = (ActivityContractFeeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)feeDto, this.getVoClass(), HashSet.class, ArrayList.class, new String[0]);
            if (!CollectionUtils.isEmpty((Collection)feeDto.getFeeDimensionList())) {
                feeVo.setFeeDimensionList(feeDto.getFeeDimensionList());
            }
            list.add(feeVo);
        }
        return list;
    }
}

