/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.service.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractMaterialRepository;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractMaterialDto;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractMaterialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ActivityContractMaterialPageCacheHelper
extends MnPageCacheHelper<ActivityContractMaterialVo, ActivityContractMaterialDto> {
    @Autowired(required=false)
    private ActivityContractMaterialRepository activityContractMaterialRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public String getCacheKeyPrefix() {
        return "activity_contract_material:item_cache:";
    }

    public Class<ActivityContractMaterialDto> getDtoClass() {
        return ActivityContractMaterialDto.class;
    }

    public Class<ActivityContractMaterialVo> getVoClass() {
        return ActivityContractMaterialVo.class;
    }

    public List<ActivityContractMaterialDto> findDtoListFromRepository(ActivityContractMaterialDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getContractNo())) {
            return Lists.newArrayList();
        }
        return this.activityContractMaterialRepository.findDtoAndAttachListByContractNo(dto.getContractNo());
    }

    public List<ActivityContractMaterialDto> newItem(String cacheKey, List<ActivityContractMaterialDto> itemList) {
        ActivityContractMaterialDto newItem = new ActivityContractMaterialDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return Lists.newArrayList((Object[])new ActivityContractMaterialDto[]{newItem});
    }

    public List<ActivityContractMaterialDto> copyItem(String cacheKey, List<ActivityContractMaterialDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityContractMaterialDto.class, ActivityContractMaterialDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (ActivityContractMaterialDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return newItemList;
    }

    public void updateItem(String cacheKey, List<ActivityContractMaterialDto> itemList) {
    }

    public Object getDtoKey(ActivityContractMaterialDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(ActivityContractMaterialDto dto) {
        return dto.getChecked();
    }

    public void importNewItem(String cacheKey, List<ActivityContractMaterialDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        for (ActivityContractMaterialDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTenantCode(TenantUtils.getTenantCode());
        }
        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        Map updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }
}

