/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractFeeDimension;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractFeeDimensionRepository;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractFeeDimensionService;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractFeeDimensionDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="activityContractFeeDimensionService")
public class ActivityContractFeeDimensionServiceImpl
implements ActivityContractFeeDimensionService {
    @Autowired(required=false)
    private ActivityContractFeeDimensionRepository activityContractFeeDimensionRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchEdit(List<ActivityContractFeeDimensionDto> dtoList, String contractNo, String tenantCode) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (ActivityContractFeeDimensionDto item : dtoList) {
            if (StringUtils.isBlank((CharSequence)item.getId())) {
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setId(UUID.randomUUID().toString().replace("-", ""));
            }
            item.setTenantCode(tenantCode);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(ActivityContractFeeDimension::getContractNo, (Object)contractNo);
        this.activityContractFeeDimensionRepository.remove((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty(dtoList)) {
            Collection dimensions = this.nebulaToolkitService.copyCollectionByBlankList(dtoList, ActivityContractFeeDimensionDto.class, ActivityContractFeeDimension.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.activityContractFeeDimensionRepository.saveBatch(dimensions);
        }
    }
}

