/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractFeeFormula;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractFeeFormulaRepository;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractFeeFormulaService;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractFeeFormulaDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="activityContractFeeFormulaService")
public class ActivityContractFeeFormulaServiceImpl
implements ActivityContractFeeFormulaService {
    @Autowired(required=false)
    private ActivityContractFeeFormulaRepository activityContractFeeFormulaRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchEdit(List<ActivityContractFeeFormulaDto> dtoList, String tenantCode) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (ActivityContractFeeFormulaDto item : dtoList) {
            if (StringUtils.isBlank((CharSequence)item.getId())) {
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setId(UUID.randomUUID().toString().replace("-", ""));
            }
            item.setTenantCode(tenantCode);
            idList.add(item.getId());
        }
        if (!CollectionUtils.isEmpty(idList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityContractFeeFormulaRepository.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).notIn(UuidEntity::getId, idList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
        }
        if (!CollectionUtils.isEmpty(dtoList)) {
            Collection shoulds = this.nebulaToolkitService.copyCollectionByBlankList(dtoList, ActivityContractFeeFormulaDto.class, ActivityContractFeeFormula.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.activityContractFeeFormulaRepository.saveOrUpdateBatch(shoulds);
        }
    }
}

