/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractFee;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractScope;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractFeeRepository;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractScopeRepository;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractFeeDimensionService;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractFeeFormulaService;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractFeeService;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractFeeDimensionDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractFeeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractFeeFormulaDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractScopeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractVariableEventDto;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractScopeTypeEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.event.ActivityContractVariableEventListener;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractFeeVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivtiyContractVariableResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="activityContractFeeService")
public class ActivityContractFeeServiceImpl
extends MnPageCacheServiceImpl<ActivityContractFeeVo, ActivityContractFeeDto>
implements ActivityContractFeeService {
    @Autowired(required=false)
    private ActivityContractFeeRepository activityContractFeeRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ActivityContractFeeFormulaService activityContractFeeFormulaService;
    @Autowired(required=false)
    private ActivityContractFeeDimensionService activityContractFeeDimensionService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ActivityContractScopeRepository activityContractScopeRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchEdit(List<ActivityContractFeeDto> feeList, String cntractNo, String tenantCode) {
        if (CollectionUtils.isEmpty(feeList)) {
            return;
        }
        ArrayList<ActivityContractFeeFormulaDto> feeFormulaDtoList = new ArrayList<ActivityContractFeeFormulaDto>();
        ArrayList<ActivityContractFeeDimensionDto> dimensionDtoList = new ArrayList<ActivityContractFeeDimensionDto>();
        ArrayList<String> idList = new ArrayList<String>();
        for (ActivityContractFeeDto item : feeList) {
            if (StringUtils.isBlank((CharSequence)item.getId())) {
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setId(UUID.randomUUID().toString().replace("-", ""));
            }
            item.setBudgetMouth(null);
            item.setContractNo(cntractNo);
            item.setTenantCode(tenantCode);
            idList.add(item.getId());
        }
        if (!CollectionUtils.isEmpty(idList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityContractFeeRepository.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).notIn(UuidEntity::getId, idList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
        }
        if (!CollectionUtils.isEmpty(feeList)) {
            this.packageData(feeFormulaDtoList, dimensionDtoList, feeList);
            Collection fees = this.nebulaToolkitService.copyCollectionByBlankList(feeList, ActivityContractFeeDto.class, ActivityContractFee.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.activityContractFeeRepository.saveOrUpdateBatch(fees);
            this.saveOrUpdateFeeScope(feeList);
        }
        this.activityContractFeeFormulaService.batchEdit(feeFormulaDtoList, tenantCode);
        this.activityContractFeeDimensionService.batchEdit(dimensionDtoList, cntractNo, tenantCode);
    }

    private void saveOrUpdateFeeScope(List<ActivityContractFeeDto> feeList) {
        if (CollectionUtils.isEmpty(feeList)) {
            return;
        }
        for (ActivityContractFeeDto fee : feeList) {
            List ids;
            ArrayList list = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)fee.getStoresContainsList())) {
                fee.getStoresContainsList().forEach(stores -> {
                    stores.setId(null);
                    stores.setContractNo(fee.getContractFeeCode());
                    stores.setContractFeeCode(fee.getContractFeeCode());
                    stores.setTenantCode(TenantUtils.getTenantCode());
                    stores.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    stores.setScopeType(ContractScopeTypeEnum.STORES.getCode());
                    stores.setScopeContains(BooleanEnum.TRUE.getCapital());
                    stores.setScopeCode(stores.getTerminalCode());
                    stores.setScopeName(stores.getTerminalName());
                });
                List storesList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)fee.getStoresContainsList(), ActivityContractScopeDto.class, ActivityContractScope.class, HashSet.class, ArrayList.class, new String[0]);
                list.addAll(storesList);
            }
            if (!CollectionUtils.isEmpty((Collection)fee.getStoresNotContainsList())) {
                fee.getStoresNotContainsList().forEach(storesNot -> {
                    storesNot.setId(null);
                    storesNot.setContractNo(fee.getContractFeeCode());
                    storesNot.setContractFeeCode(fee.getContractFeeCode());
                    storesNot.setTenantCode(TenantUtils.getTenantCode());
                    storesNot.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    storesNot.setScopeType(ContractScopeTypeEnum.STORES.getCode());
                    storesNot.setScopeContains(BooleanEnum.FALSE.getCapital());
                    storesNot.setScopeCode(storesNot.getTerminalCode());
                    storesNot.setScopeName(storesNot.getTerminalName());
                });
                List storesNotList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)fee.getStoresNotContainsList(), ActivityContractScopeDto.class, ActivityContractScope.class, HashSet.class, ArrayList.class, new String[0]);
                list.addAll(storesNotList);
            }
            if (!CollectionUtils.isEmpty(ids = list.stream().filter(i -> StringUtils.isNotEmpty((CharSequence)i.getId())).map(UuidEntity::getId).collect(Collectors.toList()))) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityContractScopeRepository.lambdaUpdate().eq(ActivityContractScope::getContractFeeCode, (Object)fee.getContractFeeCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).notIn(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
            } else {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityContractScopeRepository.lambdaUpdate().eq(ActivityContractScope::getContractFeeCode, (Object)fee.getContractFeeCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
            }
            this.activityContractScopeRepository.saveOrUpdateBatch(list);
        }
    }

    @Override
    public List<ActivityContractFeeVo> findFeeByCode(ActivityContractFeeDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getContractNo())) {
            return new ArrayList<ActivityContractFeeVo>();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractFeeRepository.lambdaQuery().eq(ActivityContractFee::getContractNo, (Object)dto.getContractNo())).eq(ActivityContractFee::getActivityFormCode, (Object)dto.getActivityFormCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Collection activityContractFeeVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)list, ActivityContractFee.class, ActivityContractFeeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return (List)activityContractFeeVos;
        }
        return new ArrayList<ActivityContractFeeVo>();
    }

    @Override
    public ActivtiyContractVariableResponse textEvent() {
        ActivityContractVariableEventDto eventDto = new ActivityContractVariableEventDto();
        eventDto.setIsConfigure(BooleanEnum.FALSE.getNumStr());
        SerializableBiConsumer & Serializable getContractVariable = ActivityContractVariableEventListener::getContractVariable;
        EventResponse eventResponse = this.nebulaNetEventClient.directPublish((NebulaEventDto)eventDto, ActivityContractVariableEventListener.class, (SerializableBiConsumer)getContractVariable);
        Validate.notNull((Object)eventResponse, (String)"\u83b7\u53d6\u5408\u540c\u53d8\u91cf\uff0c\u4e8b\u4ef6\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        return (ActivtiyContractVariableResponse)eventResponse;
    }

    public void packageData(List<ActivityContractFeeFormulaDto> feeFormulaDtoList, List<ActivityContractFeeDimensionDto> dimensionDtoList, List<ActivityContractFeeDto> feeList) {
        if (CollectionUtils.isEmpty(feeList)) {
            return;
        }
        int count = (int)feeList.stream().filter(i -> StringUtils.isBlank((CharSequence)i.getContractFeeCode())).count();
        List codes = new ArrayList(count);
        if (0 != count) {
            codes = this.generateCodeService.generateCode("HTMX", count, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        }
        int k = 0;
        for (ActivityContractFeeDto feeDto : feeList) {
            if (StringUtils.isBlank((CharSequence)feeDto.getContractFeeCode())) {
                feeDto.setContractFeeCode((String)codes.get(k));
                ++k;
            }
            if (CollectionUtils.isEmpty((Collection)feeDto.getFeeDimensionList())) continue;
            HashSet set = new HashSet(feeDto.getFeeDimensionList());
            for (String s : set) {
                ActivityContractFeeDimensionDto dimensionDto = new ActivityContractFeeDimensionDto();
                dimensionDto.setContractNo(feeDto.getContractNo());
                dimensionDto.setContractFeeCode(feeDto.getContractFeeCode());
                dimensionDto.setFeeDimensionCode(s);
                dimensionDtoList.add(dimensionDto);
            }
        }
    }
}

