/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractMaterial;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractMaterialRepository;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractMaterialService;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractMaterialDto;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractMaterialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="activityContractMaterialService")
public class ActivityContractMaterialServiceImpl
extends MnPageCacheServiceImpl<ActivityContractMaterialVo, ActivityContractMaterialDto>
implements ActivityContractMaterialService {
    private static final Logger log = LoggerFactory.getLogger(ActivityContractMaterialServiceImpl.class);
    @Autowired(required=false)
    private ActivityContractMaterialRepository activityContractMaterialRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchEdit(List<ActivityContractMaterialDto> materialList, String contractNo, String tenantCode) {
        if (CollectionUtils.isEmpty(materialList)) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (ActivityContractMaterialDto item : materialList) {
            if (StringUtils.isBlank((CharSequence)item.getId())) {
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setId(UUID.randomUUID().toString().replace("-", ""));
            }
            item.setContractNo(contractNo);
            item.setTenantCode(tenantCode);
            idList.add(item.getId());
        }
        if (!CollectionUtils.isEmpty(idList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityContractMaterialRepository.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(ActivityContractMaterial::getContractNo, (Object)contractNo)).notIn(UuidEntity::getId, idList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
        }
        if (!CollectionUtils.isEmpty(materialList)) {
            Collection materials = this.nebulaToolkitService.copyCollectionByBlankList(materialList, ActivityContractMaterialDto.class, ActivityContractMaterial.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.activityContractMaterialRepository.saveOrUpdateBatch(materials);
        }
    }
}

