/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractReconciliation;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractReconciliationRepository;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractReconciliationService;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractReconciliationDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="activityContractReconciliationService")
public class ActivityContractReconciliationServiceImpl
implements ActivityContractReconciliationService {
    @Autowired(required=false)
    private ActivityContractReconciliationRepository activityContractReconciliationRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchEdit(List<ActivityContractReconciliationDto> reconList, String cntractNo, String tenantCode) {
        Collection recons;
        if (CollectionUtils.isEmpty(reconList)) {
            return;
        }
        ArrayList<ActivityContractReconciliationDto> newFeeList = new ArrayList<ActivityContractReconciliationDto>();
        ArrayList<String> idList = new ArrayList<String>();
        for (ActivityContractReconciliationDto item : reconList) {
            if (StringUtils.isBlank((CharSequence)item.getId())) {
                item.setContractNo(cntractNo);
                item.setTenantCode(tenantCode);
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setId(null);
                newFeeList.add(item);
                continue;
            }
            idList.add(item.getId());
        }
        if (!CollectionUtils.isEmpty(idList)) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).notIn(UuidEntity::getId, idList);
            this.activityContractReconciliationRepository.remove((Wrapper)wrapper);
        }
        reconList.removeAll(newFeeList);
        if (!CollectionUtils.isEmpty(reconList)) {
            recons = this.nebulaToolkitService.copyCollectionByBlankList(reconList, ActivityContractReconciliationDto.class, ActivityContractReconciliation.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.activityContractReconciliationRepository.updateBatchByIdAndTenantCode(recons, tenantCode);
        }
        if (!CollectionUtils.isEmpty(newFeeList)) {
            recons = this.nebulaToolkitService.copyCollectionByBlankList(newFeeList, ActivityContractReconciliationDto.class, ActivityContractReconciliation.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.activityContractReconciliationRepository.saveBatch(recons);
        }
    }
}

