/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.contract.platform.sdk.dto.ContractPlatformSelectDto;
import com.biz.crm.mn.third.system.contract.platform.sdk.service.ContractPlatformService;
import com.biz.crm.mn.third.system.contract.platform.sdk.vo.ContractInvoiceVo;
import com.biz.crm.mn.third.system.contract.platform.sdk.vo.ContractPaymentVo;
import com.biz.crm.mn.third.system.contract.platform.sdk.vo.ContractPlatformVo;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContract;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractMaterialRepository;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractRepository;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractService;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractCodeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractMaterialDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractThirdDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractThirdInvoiceDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractThirdPaymentDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ContractPlatformSyncDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.log.ActivityContractLogEventDto;
import com.biz.crm.tpm.business.activity.contract.sdk.event.log.ActivityContractEventListener;
import com.biz.crm.tpm.business.activity.contract.sdk.service.ActivityContractSdkService;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractFormulaVariableVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractMaterialVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activityContractSdkService")
public class ActivityContractSdkServiceImpl
implements ActivityContractSdkService {
    private static final Logger log = LoggerFactory.getLogger(ActivityContractSdkServiceImpl.class);
    @Autowired(required=false)
    private ActivityContractRepository activityContractRepository;
    @Autowired(required=false)
    private ActivityContractMaterialRepository activityContractMaterialRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ActivityContractService activityContractService;
    @Autowired(required=false)
    private ContractPlatformService contractPlatformService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public Page<ActivityContractVo> findByConditions(Pageable pageable, ActivityContractDto activityContractDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(activityContractDto)) {
            activityContractDto = new ActivityContractDto();
        }
        return this.activityContractRepository.findByConditions(pageable, activityContractDto);
    }

    public List<ActivityContractVo> findByCodeList(List<String> codeList) {
        return this.activityContractRepository.findByCodeList(codeList);
    }

    public void saveThirdSystemContractAndLog(ActivityContractThirdDto thirdDto) {
        int count = ((LambdaQueryChainWrapper)this.activityContractRepository.lambdaQuery().eq(ActivityContract::getContractNo, (Object)thirdDto.getContractNo())).count();
        if (count >= 1) {
            return;
        }
        ActivityContract contract = this.activityContractService.saveThirdSystemContract(thirdDto);
        ActivityContractLogEventDto logEventDto = new ActivityContractLogEventDto();
        logEventDto.setOriginal(null);
        ActivityContractDto newDto = (ActivityContractDto)this.nebulaToolkitService.copyObjectByBlankList((Object)contract, ActivityContractDto.class, null, null, new String[0]);
        logEventDto.setNewest(newDto);
        SerializableBiConsumer & Serializable onCreate = ActivityContractEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityContractEventListener.class, (SerializableBiConsumer)onCreate);
    }

    public void saveThirdSystemContractBatchAndLog(List<ActivityContractThirdDto> list) {
        List<ActivityContract> contractList = this.activityContractService.saveThirdSystemContractBatch(list);
        if (CollectionUtils.isEmpty(contractList)) {
            return;
        }
        Collection newDtoList = this.nebulaToolkitService.copyCollectionByBlankList(contractList, ActivityContract.class, ActivityContractDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onCreate = ActivityContractEventListener::onCreate;
        for (ActivityContractDto dto : newDtoList) {
            ActivityContractLogEventDto logEventDto = new ActivityContractLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityContractEventListener.class, (SerializableBiConsumer)onCreate);
        }
    }

    public List<ActivityContractFormulaVariableVo> getFormulaVariable() {
        ArrayList<ActivityContractFormulaVariableVo> list = new ArrayList<ActivityContractFormulaVariableVo>();
        ActivityContractFormulaVariableVo vo1 = new ActivityContractFormulaVariableVo();
        vo1.setCode("YRL");
        vo1.setName("\u6708\u9500\u552e\u6570\u91cf\uff08YRL)");
        vo1.setSort(Integer.valueOf(1));
        list.add(vo1);
        ActivityContractFormulaVariableVo vo2 = new ActivityContractFormulaVariableVo();
        vo2.setCode("YXL");
        vo2.setName("\u5b63\u5ea6\u9500\u552e\u91d1\u989d\uff08YXL\uff09");
        vo2.setSort(Integer.valueOf(2));
        list.add(vo1);
        ActivityContractFormulaVariableVo vo3 = new ActivityContractFormulaVariableVo();
        vo3.setCode("YXE");
        vo3.setName("\u53bb\u5e74\u540c\u671f\u9500\u91cf\uff08YXE\uff09");
        vo3.setSort(Integer.valueOf(3));
        list.add(vo1);
        ActivityContractFormulaVariableVo vo4 = new ActivityContractFormulaVariableVo();
        vo4.setCode("YTQXE");
        vo4.setName("\u5408\u540c\u76ee\u6807\u9500\u91cf\uff08YTQXE\uff09");
        vo4.setSort(Integer.valueOf(4));
        list.add(vo1);
        return list;
    }

    public List<ActivityContractVo> getContractByScope(ActivityContractCodeDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getSupplierCode()) && StringUtils.isBlank((CharSequence)dto.getRetailerCode()) && CollectionUtils.isEmpty((Collection)dto.getCusCodeList()) && CollectionUtils.isEmpty((Collection)dto.getStoresCodeList()) && CollectionUtils.isEmpty((Collection)dto.getAreaCodeList())) {
            return Lists.newArrayList();
        }
        List<ActivityContract> list = this.activityContractRepository.getContractByScope(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ActivityContract.class, ActivityContractVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivityContractVo> getContractByKmsParams(ActivityContractCodeDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getSalesOrgCodeList()) && CollectionUtils.isEmpty((Collection)dto.getCusCodeList())) {
            return Lists.newArrayList();
        }
        List<ActivityContractVo> list = this.activityContractRepository.getContractByKmsParams(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public List<ActivityContractVo> getContractForActivityPlan() {
        return this.activityContractService.getContractForActivityPlan();
    }

    public void syncContractPlatformByDate(ContractPlatformSyncDto dto) {
        List list;
        this.loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        ContractPlatformSelectDto selectDto = new ContractPlatformSelectDto();
        selectDto.setRemark1(dto.getRemark1());
        selectDto.setRemark2(dto.getRemark2());
        selectDto.setRemark3(dto.getRemark3());
        selectDto.setRemark4(dto.getRemark4());
        selectDto.setRemark5(dto.getRemark5());
        if (!StringUtils.isNotBlank((CharSequence)dto.getRemark3())) {
            if (Objects.isNull(dto.getStartDate()) && Objects.isNull(dto.getEndDate())) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -1);
                Date nowDate = DateUtil.strToDate((String)DateUtil.dateStrYYYYMMDD((Date)calendar.getTime()), (SimpleDateFormat)DateUtil.date_yyyy_MM_dd);
                dto.setStartDate(nowDate);
                dto.setEndDate(nowDate);
                selectDto.setStartcreatedon(DateUtil.dateToStr((Date)dto.getStartDate(), (SimpleDateFormat)DateUtil.date_yyyy_MM_dd));
                selectDto.setEndcreatedon(DateUtil.dateToStr((Date)dto.getEndDate(), (SimpleDateFormat)DateUtil.date_yyyy_MM_dd));
            } else if (Objects.isNull(dto.getStartDate()) || Objects.isNull(dto.getEndDate())) {
                throw new RuntimeException("\u8bf7\u586b\u5199\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f");
            }
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.contractPlatformService.getContractPlatformDate(selectDto)))) {
            if (!StringUtils.isEmpty((CharSequence)dto.getRemark3())) {
                throw new RuntimeException("\u5408\u540c[" + dto.getRemark3() + "]\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u5408\u540c\u5df2\u5f52\u6863");
            }
            return;
        }
        Set contractNoSet = list.stream().map(ContractPlatformVo::getContractNo).collect(Collectors.toSet());
        ArrayList<ActivityContractThirdDto> thirdList = new ArrayList<ActivityContractThirdDto>();
        for (ContractPlatformVo pVo : list) {
            ActivityContractThirdDto thirdDto = (ActivityContractThirdDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)pVo, ActivityContractThirdDto.class, null, null, new String[0]);
            if (!CollectionUtils.isEmpty((Collection)pVo.getInvoiceList())) {
                Collection invoiceDtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)pVo.getInvoiceList(), ContractInvoiceVo.class, ActivityContractThirdInvoiceDto.class, HashSet.class, ArrayList.class, new String[0]);
                thirdDto.setInvoiceList(new ArrayList(invoiceDtoList));
            }
            if (!CollectionUtils.isEmpty((Collection)pVo.getPayList())) {
                Collection paymentDtoList = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)pVo.getPayList(), ContractPaymentVo.class, ActivityContractThirdPaymentDto.class, HashSet.class, ArrayList.class, new String[0]);
                thirdDto.setPaymentList(new ArrayList(paymentDtoList));
            }
            if (!StringUtils.isEmpty((CharSequence)dto.getRemark3())) {
                thirdDto.setSyncSingle(true);
            }
            thirdList.add(thirdDto);
        }
        ArrayList contractNoList = new ArrayList(contractNoSet);
        boolean hasLock = false;
        try {
            hasLock = this.redisLockService.batchLock("third:contract_lock:", contractNoList, TimeUnit.SECONDS, 10);
            if (!hasLock) {
                throw new RuntimeException("\u5408\u540c\u6570\u636e\u6b63\u5728\u5f55\u5165\u4e2d,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001");
            }
            this.saveThirdSystemContractBatchAndLog(thirdList);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            if (hasLock) {
                this.redisLockService.batchUnLock("third:contract_lock:", contractNoList);
            }
        }
    }

    public ActivityContractMaterialVo getActivityContractMaterial(ActivityContractMaterialDto dto) {
        Validate.notBlank((CharSequence)dto.getMaterialCode(), (String)"\u67e5\u8be2\u5408\u540c\u7269\u6599\u4ef7\u683c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getContractNo(), (String)"\u67e5\u8be2\u5408\u540c\u7269\u6599\u4ef7\u683c\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getMaterialQuantity(), (String)"\u67e5\u8be2\u5408\u540c\u7269\u6599\u4ef7\u683c\u7269\u6599\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.activityContractMaterialRepository.getActivityContractMaterial(dto);
    }
}

