/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.contract.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContract;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractFee;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractFeeDimension;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractReconciliation;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractScope;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractThirdInvoice;
import com.biz.crm.tpm.business.activity.contract.local.entity.ActivityContractThirdPayment;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractFeeDimensionRepository;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractFeeFormulaRepository;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractFeeRepository;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractReconciliationRepository;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractRepository;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractScopeRepository;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractThirdInvoiceRepository;
import com.biz.crm.tpm.business.activity.contract.local.repository.ActivityContractThirdPaymentRepository;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractFeeService;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractMaterialService;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractReconciliationService;
import com.biz.crm.tpm.business.activity.contract.local.service.ActivityContractService;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractFeeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractMaterialDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractReconciliationDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractScopeDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractThirdDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractThirdInvoiceDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractThirdPaymentDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.log.ActivityContractLogEventDto;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractReconPeriodEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractReconPeriodTypeEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractScopeTypeEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractStateEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractTypeEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.event.log.ActivityContractEventListener;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractFeeVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractReconSelectDataVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractReconciliationVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractScopeVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ContractCommonSelectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="activityContractService")
public class ActivityContractServiceImpl
implements ActivityContractService {
    private static final Logger log = LoggerFactory.getLogger(ActivityContractServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityContractRepository activityContractRepository;
    @Autowired(required=false)
    private ActivityContractThirdInvoiceRepository activityContractThirdInvoiceRepository;
    @Autowired(required=false)
    private ActivityContractThirdPaymentRepository activityContractThirdPaymentRepository;
    @Autowired(required=false)
    private ActivityContractScopeRepository activityContractScopeRepository;
    @Autowired(required=false)
    private ActivityContractFeeRepository activityContractFeeRepository;
    @Autowired(required=false)
    private ActivityContractFeeFormulaRepository activityContractFeeFormulaRepository;
    @Autowired(required=false)
    private ActivityContractFeeDimensionRepository activityContractFeeDimensionRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ActivityContractFeeService activityContractFeeService;
    @Autowired(required=false)
    private ActivityContractReconciliationService activityContractReconciliationService;
    @Autowired(required=false)
    private ActivityContractReconciliationRepository activityContractReconciliationRepository;
    @Autowired(required=false)
    private ActivityContractMaterialService activityContractMaterialService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ActivityContract saveThirdSystemContract(ActivityContractThirdDto thirdDto) {
        ActivityContract contractThird = (ActivityContract)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)thirdDto, ActivityContract.class, null, null, new String[0]));
        contractThird.setTenantCode(TenantUtils.getTenantCode());
        contractThird.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        contractThird.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        contractThird.setContractState(ContractStateEnum.WAIT_CONFIRM.getCode());
        this.activityContractRepository.save((Object)contractThird);
        if (!CollectionUtils.isEmpty((Collection)thirdDto.getInvoiceList())) {
            Collection invoiceList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)thirdDto.getInvoiceList(), ActivityContractThirdInvoiceDto.class, ActivityContractThirdInvoice.class, HashSet.class, ArrayList.class, new String[0]);
            invoiceList.forEach(i -> {
                i.setContractNo(contractThird.getContractNo());
                i.setTenantCode(TenantUtils.getTenantCode());
                i.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                i.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
            this.activityContractThirdInvoiceRepository.saveBatch(invoiceList);
        }
        if (!CollectionUtils.isEmpty((Collection)thirdDto.getInvoiceList())) {
            Collection paymentList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)thirdDto.getPaymentList(), ActivityContractThirdPaymentDto.class, ActivityContractThirdPayment.class, HashSet.class, ArrayList.class, new String[0]);
            paymentList.forEach(i -> {
                i.setContractNo(contractThird.getContractNo());
                i.setTenantCode(TenantUtils.getTenantCode());
                i.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                i.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
            this.activityContractThirdPaymentRepository.saveBatch(paymentList);
        }
        return contractThird;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ActivityContract> saveThirdSystemContractBatch(List<ActivityContractThirdDto> list) {
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        log.error("\u4fdd\u5b58\u7684\u5408\u540c\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(list));
        List contractNoList = list.stream().map(ActivityContractThirdDto::getContractNo).collect(Collectors.toList());
        List oldList = ((LambdaQueryChainWrapper)this.activityContractRepository.lambdaQuery().in(ActivityContract::getContractNo, contractNoList)).list();
        Map<Object, Object> oldMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)oldList)) {
            oldMap = oldList.stream().collect(Collectors.toMap(ActivityContract::getContractNo, Function.identity()));
        }
        ArrayList<ActivityContract> newList = new ArrayList<ActivityContract>();
        ArrayList newInvoiceList = new ArrayList();
        ArrayList newPaymentList = new ArrayList();
        for (ActivityContractThirdDto thirdDto : list) {
            if (oldMap.containsKey(thirdDto.getContractNo())) {
                if (!thirdDto.isSyncSingle()) continue;
                throw new RuntimeException("\u8be5\u5408\u540c[" + thirdDto.getContractNo() + "]\u5728TPM\u4e2d\u5df2\u5b58\u5728");
            }
            ActivityContract contractThird = (ActivityContract)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)thirdDto, ActivityContract.class, null, null, new String[0]));
            contractThird.setTenantCode(TenantUtils.getTenantCode());
            contractThird.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            contractThird.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            contractThird.setContractState(ContractStateEnum.WAIT_CONFIRM.getCode());
            newList.add(contractThird);
            if (!CollectionUtils.isEmpty((Collection)thirdDto.getInvoiceList())) {
                Collection invoiceList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)thirdDto.getInvoiceList(), ActivityContractThirdInvoiceDto.class, ActivityContractThirdInvoice.class, HashSet.class, ArrayList.class, new String[0]);
                invoiceList.forEach(i -> {
                    i.setContractNo(contractThird.getContractNo());
                    i.setTenantCode(TenantUtils.getTenantCode());
                    i.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    i.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                });
                newInvoiceList.addAll(invoiceList);
            }
            if (CollectionUtils.isEmpty((Collection)thirdDto.getPaymentList())) continue;
            Collection paymentList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)thirdDto.getPaymentList(), ActivityContractThirdPaymentDto.class, ActivityContractThirdPayment.class, HashSet.class, ArrayList.class, new String[0]);
            paymentList.forEach(i -> {
                i.setContractNo(contractThird.getContractNo());
                i.setTenantCode(TenantUtils.getTenantCode());
                i.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                i.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
            newPaymentList.addAll(paymentList);
        }
        if (!CollectionUtils.isEmpty(newList)) {
            this.activityContractRepository.saveBatch(newList);
        }
        if (!CollectionUtils.isEmpty(newInvoiceList)) {
            this.activityContractThirdInvoiceRepository.saveBatch(newInvoiceList);
        }
        if (!CollectionUtils.isEmpty(newPaymentList)) {
            this.activityContractThirdPaymentRepository.saveBatch(newPaymentList);
        }
        return newList;
    }

    @Override
    public ActivityContractVo findById(String id) {
        List reconList;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ActivityContract activityContract = (ActivityContract)((Object)this.activityContractRepository.getById((Serializable)((Object)id)));
        ActivityContractVo activityContractVo = (ActivityContractVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityContract, ActivityContractVo.class, null, null, new String[0]);
        List scopeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractScopeRepository.lambdaQuery().eq(ActivityContractScope::getContractNo, (Object)activityContract.getContractNo())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (!CollectionUtils.isEmpty((Collection)scopeList)) {
            Map<String, List<ActivityContractScopeVo>> scopeMapArea;
            Collection scopeVoList = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)scopeList, ActivityContractScope.class, ActivityContractScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            Map<String, Map<String, List<ActivityContractScopeVo>>> scopeMap = scopeVoList.stream().collect(Collectors.groupingBy(ActivityContractScopeVo::getScopeType, Collectors.groupingBy(ActivityContractScopeVo::getScopeContains)));
            if (scopeMap.containsKey(ContractScopeTypeEnum.AREA.getCode())) {
                scopeMapArea = scopeMap.get(ContractScopeTypeEnum.AREA.getCode());
                activityContractVo.setAreaContainsList((List)scopeMapArea.getOrDefault(BooleanEnum.TRUE.getCapital(), null));
                activityContractVo.setAreaNotContainsList((List)scopeMapArea.getOrDefault(BooleanEnum.FALSE.getCapital(), null));
            }
            if (scopeMap.containsKey(ContractScopeTypeEnum.STORES.getCode())) {
                scopeMapArea = scopeMap.get(ContractScopeTypeEnum.STORES.getCode());
                activityContractVo.setStoresContainsList((List)scopeMapArea.getOrDefault(BooleanEnum.TRUE.getCapital(), null));
                activityContractVo.setStoresNotContainsList((List)scopeMapArea.getOrDefault(BooleanEnum.FALSE.getCapital(), null));
            }
            if (scopeMap.containsKey(ContractScopeTypeEnum.CUSTOMER.getCode())) {
                scopeMapArea = scopeMap.get(ContractScopeTypeEnum.CUSTOMER.getCode());
                activityContractVo.setCustomerContainsList((List)scopeMapArea.getOrDefault(BooleanEnum.TRUE.getCapital(), null));
                activityContractVo.setCustomerNotContainsList((List)scopeMapArea.getOrDefault(BooleanEnum.FALSE.getCapital(), null));
            }
            if (scopeMap.containsKey(ContractScopeTypeEnum.REGION.getCode())) {
                scopeMapArea = scopeMap.get(ContractScopeTypeEnum.REGION.getCode());
                activityContractVo.setRegionContainsList((List)scopeMapArea.getOrDefault(BooleanEnum.TRUE.getCapital(), null));
                activityContractVo.setRegionNotContainsList((List)scopeMapArea.getOrDefault(BooleanEnum.FALSE.getCapital(), null));
            }
            if (scopeMap.containsKey(ContractScopeTypeEnum.PRODUCT.getCode())) {
                scopeMapArea = scopeMap.get(ContractScopeTypeEnum.PRODUCT.getCode());
                activityContractVo.setProductContainsList((List)scopeMapArea.getOrDefault(BooleanEnum.TRUE.getCapital(), null));
                activityContractVo.setProductNotContainsList((List)scopeMapArea.getOrDefault(BooleanEnum.FALSE.getCapital(), null));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(reconList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractReconciliationRepository.lambdaQuery().eq(ActivityContractReconciliation::getContractNo, (Object)activityContract.getContractNo())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list()))) {
            Collection reconVoList = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)reconList, ActivityContractReconciliation.class, ActivityContractReconciliationVo.class, HashSet.class, ArrayList.class, new String[0]);
            activityContractVo.setReconDateList((List)reconVoList);
        }
        return activityContractVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(ActivityContractDto activityContractDto) {
        this.createValidate(activityContractDto);
        int count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractRepository.lambdaQuery().eq(ActivityContract::getContractNo, (Object)activityContractDto.getContractNo())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).count();
        Validate.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u6b64\u5408\u540c\u4fe1\u606f\u5df2\u5b58\u5728", (Object[])new Object[0]);
        String code = (String)this.generateCodeService.generateCode("HT", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        activityContractDto.setContractNo(code);
        activityContractDto.setContractState(ContractStateEnum.WAIT_CONFIRM.getCode());
        ActivityContract contract = (ActivityContract)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityContractDto, ActivityContract.class, null, null, new String[0]));
        contract.setTenantCode(TenantUtils.getTenantCode());
        contract.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        contract.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.activityContractRepository.save((Object)contract);
        List<ActivityContractScope> scopeList = this.packageAllScope(activityContractDto);
        if (!CollectionUtils.isEmpty(scopeList)) {
            this.activityContractScopeRepository.saveBatch(scopeList);
        }
        ArrayList formulaVoList = new ArrayList();
        List codeList = this.generateCodeService.generateCode("HTMX", activityContractDto.getFeeVoList().size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
        Collection feeList = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)activityContractDto.getFeeVoList(), ActivityContractFeeDto.class, ActivityContractFee.class, HashSet.class, ArrayList.class, new String[0]);
        feeList.forEach(item -> {
            item.setTenantCode(TenantUtils.getTenantCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });
        this.activityContractFeeRepository.saveBatch(feeList);
        ActivityContractLogEventDto logEventDto = new ActivityContractLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(activityContractDto);
        SerializableBiConsumer & Serializable onCreate = ActivityContractEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityContractEventListener.class, (SerializableBiConsumer)onCreate);
    }

    private void createValidate(ActivityContractDto activityContractDto) {
        Validate.notNull((Object)activityContractDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        activityContractDto.setId(null);
        Validate.notBlank((CharSequence)activityContractDto.getContractNo(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityContractDto.getContractName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activityContractDto.getEnableDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activityContractDto.getEndDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityContractDto.getPaymentDaysType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d26\u671f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityContractDto.getPaymentDays(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d26\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activityContractDto.getAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5408\u540c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)activityContractDto.getFeeVoList(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6263\u8d39\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (ActivityContractFeeDto feeDto : activityContractDto.getFeeVoList()) {
            Validate.notEmpty((CharSequence)feeDto.getAuditConditionCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6263\u8d39\u660e\u7ec6\u91cc\u6838\u9500\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
    }

    private List<ActivityContractScope> packageAllScope(ActivityContractDto activityContractDto) {
        List<ActivityContractScope> productNotContainsList;
        List<ActivityContractScope> productContainsList;
        List<ActivityContractScope> regionNotContainsList;
        List<ActivityContractScope> regionContainsList;
        List<ActivityContractScope> cusNotContainsList;
        List<ActivityContractScope> cusContainsList;
        List<ActivityContractScope> storesNotContainsList;
        List<ActivityContractScope> storesContainsList;
        List<ActivityContractScope> areaNotContainsList;
        ArrayList<ActivityContractScope> scopeList = new ArrayList<ActivityContractScope>();
        List<ActivityContractScope> areaContainsList = this.packageScope(activityContractDto.getAreaContainsList(), ContractScopeTypeEnum.AREA, BooleanEnum.TRUE, activityContractDto.getContractNo());
        if (!CollectionUtils.isEmpty(areaContainsList)) {
            scopeList.addAll(areaContainsList);
        }
        if (!CollectionUtils.isEmpty(areaNotContainsList = this.packageScope(activityContractDto.getAreaNotContainsList(), ContractScopeTypeEnum.AREA, BooleanEnum.FALSE, activityContractDto.getContractNo()))) {
            scopeList.addAll(areaNotContainsList);
        }
        if (!CollectionUtils.isEmpty(storesContainsList = this.packageScope(activityContractDto.getStoresContainsList(), ContractScopeTypeEnum.STORES, BooleanEnum.TRUE, activityContractDto.getContractNo()))) {
            scopeList.addAll(storesContainsList);
        }
        if (!CollectionUtils.isEmpty(storesNotContainsList = this.packageScope(activityContractDto.getStoresNotContainsList(), ContractScopeTypeEnum.STORES, BooleanEnum.FALSE, activityContractDto.getContractNo()))) {
            scopeList.addAll(storesNotContainsList);
        }
        if (!CollectionUtils.isEmpty(cusContainsList = this.packageScope(activityContractDto.getCustomerContainsList(), ContractScopeTypeEnum.CUSTOMER, BooleanEnum.TRUE, activityContractDto.getContractNo()))) {
            scopeList.addAll(cusContainsList);
        }
        if (!CollectionUtils.isEmpty(cusNotContainsList = this.packageScope(activityContractDto.getCustomerNotContainsList(), ContractScopeTypeEnum.CUSTOMER, BooleanEnum.FALSE, activityContractDto.getContractNo()))) {
            scopeList.addAll(cusNotContainsList);
        }
        if (!CollectionUtils.isEmpty(regionContainsList = this.packageScope(activityContractDto.getRegionContainsList(), ContractScopeTypeEnum.REGION, BooleanEnum.TRUE, activityContractDto.getContractNo()))) {
            scopeList.addAll(regionContainsList);
        }
        if (!CollectionUtils.isEmpty(regionNotContainsList = this.packageScope(activityContractDto.getRegionNotContainsList(), ContractScopeTypeEnum.REGION, BooleanEnum.FALSE, activityContractDto.getContractNo()))) {
            scopeList.addAll(regionNotContainsList);
        }
        if (!CollectionUtils.isEmpty(productContainsList = this.packageScope(activityContractDto.getProductContainsList(), ContractScopeTypeEnum.PRODUCT, BooleanEnum.TRUE, activityContractDto.getContractNo()))) {
            scopeList.addAll(productContainsList);
        }
        if (!CollectionUtils.isEmpty(productNotContainsList = this.packageScope(activityContractDto.getProductNotContainsList(), ContractScopeTypeEnum.PRODUCT, BooleanEnum.FALSE, activityContractDto.getContractNo()))) {
            scopeList.addAll(productNotContainsList);
        }
        return scopeList;
    }

    private List<ActivityContractScope> packageScope(List<ActivityContractScopeDto> scopeVoList, ContractScopeTypeEnum typeEnum, BooleanEnum booleanEnum, String activityContractNo) {
        if (CollectionUtils.isEmpty(scopeVoList)) {
            return null;
        }
        Collection scopeList = this.nebulaToolkitService.copyCollectionByBlankList(scopeVoList, ActivityContractScopeDto.class, ActivityContractScope.class, HashSet.class, ArrayList.class, new String[0]);
        for (ActivityContractScope scope : scopeList) {
            if (StringUtils.isNotEmpty((CharSequence)scope.getId())) continue;
            scope.setContractNo(activityContractNo);
            scope.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            scope.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            scope.setScopeType(typeEnum.getCode());
            scope.setScopeContains(booleanEnum.getCapital());
            scope.setTenantCode(TenantUtils.getTenantCode());
        }
        return (List)scopeList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(String itemCacheKey, ActivityContractDto activityContractDto) {
        List itemCacheList;
        this.updateValidate(activityContractDto);
        int count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractRepository.lambdaQuery().eq(ActivityContract::getContractNo, (Object)activityContractDto.getContractNo())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).ne(UuidEntity::getId, (Object)activityContractDto.getId())).count();
        Validate.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u6b64\u5408\u540c\u4fe1\u606f\u5df2\u5b58\u5728", (Object[])new Object[0]);
        ActivityContractVo oldVo = this.findById(activityContractDto.getId());
        activityContractDto.setContractState(ContractStateEnum.WAIT_CONFIRM.getCode());
        ActivityContract contract = (ActivityContract)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityContractDto, ActivityContract.class, null, null, new String[0]));
        this.activityContractRepository.updateById((Object)contract);
        List<ActivityContractScope> scopeList = this.packageAllScope(activityContractDto);
        if (!CollectionUtils.isEmpty(scopeList)) {
            List ids = scopeList.stream().filter(i -> StringUtils.isNotEmpty((CharSequence)i.getId())).map(UuidEntity::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(ids)) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityContractScopeRepository.lambdaUpdate().eq(ActivityContractScope::getContractNo, (Object)contract.getContractNo())).notIn(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
            } else {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.activityContractScopeRepository.lambdaUpdate().eq(ActivityContractScope::getContractNo, (Object)contract.getContractNo())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
            }
            this.activityContractScopeRepository.saveOrUpdateBatch(scopeList);
        }
        this.activityContractReconciliationService.batchEdit(activityContractDto.getReconDateList(), contract.getContractNo(), TenantUtils.getTenantCode());
        if (ContractTypeEnum.RESALE_COMMERCIAL_CONTRACT.getCode().equals(activityContractDto.getContractType())) {
            itemCacheList = this.activityContractFeeService.findCacheList(itemCacheKey);
            this.activityContractFeeService.batchEdit(itemCacheList, contract.getContractNo(), TenantUtils.getTenantCode());
            this.activityContractFeeService.clearCache(itemCacheKey);
        } else if (ContractTypeEnum.SUPPLIER_CONTRACT.getCode().equals(activityContractDto.getContractType())) {
            itemCacheList = this.activityContractMaterialService.findCacheList(itemCacheKey);
            for (ActivityContractMaterialDto materialDto : itemCacheList) {
                Assert.notNull((Object)materialDto, (String)"\u7269\u6599\u4fe1\u606f\u6761\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.notNull((Object)materialDto.getQualityOne(), (String)"[\u7269\u6599\u4fe1\u606f]\u4e0b\u7684\u201c\u8bf7\u8f93\u5165\u6700\u4f4e\u6570\u91cf\u201d\u5b57\u6bb5\u672a\u586b\u5199");
                Assert.notNull((Object)materialDto.getSymbolOne(), (String)"[\u7269\u6599\u4fe1\u606f]\u4e0b\u7684\u201c\u8bf7\u8f93\u5165\u6700\u4f4e\u6570\u91cf\u201d\u5b57\u6bb5\u540e\u201d\u7b26\u53f7\u201d\u5b57\u6bb5\u672a\u586b\u5199");
                Assert.notNull((Object)materialDto.getSymbolTwo(), (String)"[\u7269\u6599\u4fe1\u606f]\u4e0b\u7684\u201c\u8bf7\u8f93\u5165\u6700\u9ad8\u6570\u91cf\u201d\u5b57\u6bb5\u524d\u201c\u7b26\u53f7\u201d\u5b57\u6bb5\u672a\u586b\u5199");
                Assert.notNull((Object)materialDto.getQualityTwo(), (String)"[\u7269\u6599\u4fe1\u606f]\u4e0b\u7684\u201c\u8bf7\u8f93\u5165\u6700\u9ad8\u6570\u91cf\u201d\u5b57\u6bb5\u672a\u586b\u5199");
            }
            this.activityContractMaterialService.batchEdit(itemCacheList, contract.getContractNo(), TenantUtils.getTenantCode());
            this.activityContractMaterialService.clearCache(itemCacheKey);
        }
        ActivityContractLogEventDto logEventDto = new ActivityContractLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(activityContractDto);
        SerializableBiConsumer & Serializable onUpdate = ActivityContractEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityContractEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirmById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        ActivityContract contract = (ActivityContract)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractRepository.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(ActivityContract::getContractState, (Object)ContractStateEnum.WAIT_CONFIRM.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        if (null != contract) {
            contract.setContractState(ContractStateEnum.CONFIRMED.getCode());
            this.activityContractRepository.updateById((Object)contract);
        }
    }

    @Override
    public List<ActivityContractVo> getContractForActivityPlan() {
        Calendar lastTime = Calendar.getInstance();
        int lastDay = lastTime.getActualMaximum(5);
        lastTime.set(5, lastDay);
        Calendar firstTime = Calendar.getInstance();
        firstTime.set(5, 1);
        List activityContractList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractRepository.lambdaQuery().eq(ActivityContract::getContractState, (Object)ContractStateEnum.CONFIRMED.getCode())).eq(ActivityContract::getContractType, (Object)ContractTypeEnum.RESALE_COMMERCIAL_CONTRACT.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).ge(ActivityContract::getEndDate, (Object)firstTime.getTime())).lt(ActivityContract::getEnableDate, (Object)lastTime.getTime())).eq(ActivityContract::getBusinessUnitCode, (Object)BusinessUnitEnum.VERTICAL.getCode())).list();
        ArrayList<ActivityContractVo> activityContractVoList = new ArrayList<ActivityContractVo>();
        if (!CollectionUtils.isEmpty((Collection)activityContractList)) {
            Set contractNoSet = activityContractList.stream().map(ActivityContract::getContractNo).collect(Collectors.toSet());
            List contractFeeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractFeeRepository.lambdaQuery().in(ActivityContractFee::getContractNo, contractNoSet)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
            Map<String, List<ActivityContractFee>> activityContractFeeMap = contractFeeList.stream().collect(Collectors.groupingBy(ActivityContractFee::getContractNo));
            List contractFeeCodeList = contractFeeList.stream().map(ActivityContractFee::getContractFeeCode).collect(Collectors.toList());
            List activityContractScopeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractScopeRepository.lambdaQuery().in(ActivityContractScope::getContractNo, contractNoSet)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
            Map<String, List<ActivityContractScope>> allActivityContractScopeMap = activityContractScopeList.stream().collect(Collectors.groupingBy(ActivityContractScope::getContractNo));
            List activityContractFeeScopeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractScopeRepository.lambdaQuery().in(ActivityContractScope::getContractFeeCode, contractFeeCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
            Map<String, List<ActivityContractScope>> activityContractFeeScopeMap = activityContractFeeScopeList.stream().collect(Collectors.groupingBy(ActivityContractScope::getContractFeeCode));
            List activityContractFeeDimensionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityContractFeeDimensionRepository.lambdaQuery().in(ActivityContractFeeDimension::getContractNo, contractNoSet)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
            Map<Object, Object> activityContractFeeDimensionMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)activityContractFeeDimensionList)) {
                activityContractFeeDimensionMap = activityContractFeeDimensionList.stream().collect(Collectors.groupingBy(o -> o.getContractNo() + o.getContractFeeCode()));
            }
            for (ActivityContract activityContract : activityContractList) {
                List<ActivityContractFee> activityContractFees;
                ActivityContractVo activityContractVo = (ActivityContractVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityContract, ActivityContractVo.class, null, null, new String[0]);
                List<ActivityContractScope> thisActivityContractScopeList = allActivityContractScopeMap.get(activityContractVo.getContractNo());
                Map<Object, Object> activityContractScopeMap = new HashMap();
                if (!CollectionUtils.isEmpty(thisActivityContractScopeList)) {
                    activityContractScopeMap = thisActivityContractScopeList.stream().collect(Collectors.groupingBy(ActivityContractScope::getScopeType, Collectors.groupingBy(ActivityContractScope::getScopeContains)));
                }
                if (!CollectionUtils.isEmpty(activityContractFees = activityContractFeeMap.get(activityContract.getContractNo()))) {
                    Map productMap;
                    Map regionMap;
                    Map customerMap;
                    Collection activityContractFeeVos = this.nebulaToolkitService.copyCollectionByBlankList(activityContractFees, ActivityContractFee.class, ActivityContractFeeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    for (ActivityContractFeeVo activityContractFeeVo : activityContractFeeVos) {
                        List activityContractFeeDimensionList1 = (List)activityContractFeeDimensionMap.get(activityContractFeeVo.getContractNo() + activityContractFeeVo.getContractFeeCode());
                        if (CollectionUtils.isEmpty((Collection)activityContractFeeDimensionList1)) continue;
                        activityContractFeeVo.setFeeDimensionList(activityContractFeeDimensionList1.stream().map(ActivityContractFeeDimension::getFeeDimensionCode).collect(Collectors.toList()));
                    }
                    activityContractVo.setFeeVoList((List)activityContractFeeVos);
                    Map areaMap = (Map)activityContractScopeMap.get(ContractScopeTypeEnum.AREA.getCode());
                    if (areaMap != null) {
                        Collection activityContractScopeVos;
                        Object areaList = (List)areaMap.get(BooleanEnum.TRUE.getCapital());
                        if (!CollectionUtils.isEmpty((Collection)areaList)) {
                            activityContractScopeVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)areaList, ActivityContractScope.class, ActivityContractScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                            activityContractVo.setAreaContainsList((List)activityContractScopeVos);
                        }
                        if (!CollectionUtils.isEmpty((Collection)(areaList = (List)areaMap.get(BooleanEnum.FALSE.getCapital())))) {
                            activityContractScopeVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)areaList, ActivityContractScope.class, ActivityContractScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                            activityContractVo.setAreaNotContainsList((List)activityContractScopeVos);
                        }
                    }
                    for (ActivityContractFeeVo activityContractFeeVo : activityContractVo.getFeeVoList()) {
                        List<ActivityContractScope> activityContractScopes = activityContractFeeScopeMap.get(activityContractFeeVo.getContractFeeCode());
                        if (null == activityContractScopes) continue;
                        List storeContainsList = (List)this.nebulaToolkitService.copyCollectionByBlankList(activityContractScopes, ActivityContractScope.class, ActivityContractScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                        activityContractFeeVo.setStoresContainsList(storeContainsList.stream().filter(item -> BooleanEnum.TRUE.getCapital().equals(item.getScopeContains())).collect(Collectors.toList()));
                        activityContractFeeVo.setStoresNotContainsList(storeContainsList.stream().filter(item -> BooleanEnum.FALSE.getCapital().equals(item.getScopeContains())).collect(Collectors.toList()));
                    }
                    Map storesMap = (Map)activityContractScopeMap.get(ContractScopeTypeEnum.STORES.getCode());
                    if (storesMap != null) {
                        List headAreaList;
                        Collection activityContractScopeVos;
                        List storesList = (List)storesMap.get(BooleanEnum.TRUE.getCapital());
                        if (!CollectionUtils.isEmpty((Collection)storesList)) {
                            activityContractScopeVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)storesList, ActivityContractScope.class, ActivityContractScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                            headAreaList = activityContractScopeVos.stream().filter(item -> StringUtils.isEmpty((CharSequence)item.getContractFeeCode())).collect(Collectors.toList());
                            activityContractVo.setStoresContainsList(headAreaList);
                        }
                        if (!CollectionUtils.isEmpty((Collection)(storesList = (List)storesMap.get(BooleanEnum.FALSE.getCapital())))) {
                            activityContractScopeVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)storesList, ActivityContractScope.class, ActivityContractScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                            headAreaList = activityContractScopeVos.stream().filter(item -> StringUtils.isEmpty((CharSequence)item.getContractFeeCode())).collect(Collectors.toList());
                            activityContractVo.setStoresNotContainsList(headAreaList);
                        }
                    }
                    if ((customerMap = (Map)activityContractScopeMap.get(ContractScopeTypeEnum.CUSTOMER.getCode())) != null) {
                        Collection activityContractScopeVos;
                        List customersList = (List)customerMap.get(BooleanEnum.TRUE.getCapital());
                        if (!CollectionUtils.isEmpty((Collection)customersList)) {
                            activityContractScopeVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)customersList, ActivityContractScope.class, ActivityContractScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                            activityContractVo.setCustomerContainsList((List)activityContractScopeVos);
                        }
                        if (!CollectionUtils.isEmpty((Collection)(customersList = (List)customerMap.get(BooleanEnum.FALSE.getCapital())))) {
                            activityContractScopeVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)customersList, ActivityContractScope.class, ActivityContractScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                            activityContractVo.setStoresNotContainsList((List)activityContractScopeVos);
                        }
                    }
                    if ((regionMap = (Map)activityContractScopeMap.get(ContractScopeTypeEnum.REGION.getCode())) != null) {
                        Collection activityContractScopeVos;
                        List regionsList = (List)regionMap.get(BooleanEnum.TRUE.getCapital());
                        if (!CollectionUtils.isEmpty((Collection)regionsList)) {
                            activityContractScopeVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)regionsList, ActivityContractScope.class, ActivityContractScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                            activityContractVo.setRegionContainsList((List)activityContractScopeVos);
                        }
                        if (!CollectionUtils.isEmpty((Collection)(regionsList = (List)regionMap.get(BooleanEnum.FALSE.getCapital())))) {
                            activityContractScopeVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)regionsList, ActivityContractScope.class, ActivityContractScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                            activityContractVo.setRegionNotContainsList((List)activityContractScopeVos);
                        }
                    }
                    if ((productMap = (Map)activityContractScopeMap.get(ContractScopeTypeEnum.PRODUCT.getCode())) != null) {
                        Collection activityContractScopeVos;
                        List productList = (List)productMap.get(BooleanEnum.TRUE.getCapital());
                        if (!CollectionUtils.isEmpty((Collection)productList)) {
                            activityContractScopeVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)productList, ActivityContractScope.class, ActivityContractScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                            activityContractVo.setProductContainsList((List)activityContractScopeVos);
                        }
                        if (!CollectionUtils.isEmpty((Collection)(productList = (List)productMap.get(BooleanEnum.FALSE.getCapital())))) {
                            activityContractScopeVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)productList, ActivityContractScope.class, ActivityContractScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                            activityContractVo.setProductNotContainsList((List)activityContractScopeVos);
                        }
                    }
                }
                activityContractVoList.add(activityContractVo);
            }
        }
        return activityContractVoList;
    }

    @Override
    public ActivityContractReconSelectDataVo getContractReconSelectData(String reconPeriod) {
        ActivityContractReconSelectDataVo dataVo = new ActivityContractReconSelectDataVo();
        if (StringUtils.isBlank((CharSequence)reconPeriod)) {
            return null;
        }
        if (ContractReconPeriodEnum.DAY.getCode().equals(reconPeriod)) {
            return null;
        }
        if (ContractReconPeriodEnum.WEEK.getCode().equals(reconPeriod)) {
            dataVo.setNotice(ContractReconPeriodEnum.WEEK.getValue());
            ContractCommonSelectVo selectVo1 = new ContractCommonSelectVo();
            selectVo1.setCode(Integer.valueOf(1));
            selectVo1.setValue("\u5468\u4e00");
            ContractCommonSelectVo selectVo2 = new ContractCommonSelectVo();
            selectVo2.setCode(Integer.valueOf(2));
            selectVo2.setValue("\u5468\u4e8c");
            ContractCommonSelectVo selectVo3 = new ContractCommonSelectVo();
            selectVo3.setCode(Integer.valueOf(3));
            selectVo3.setValue("\u5468\u4e09");
            ContractCommonSelectVo selectVo4 = new ContractCommonSelectVo();
            selectVo4.setCode(Integer.valueOf(4));
            selectVo4.setValue("\u5468\u56db");
            ContractCommonSelectVo selectVo5 = new ContractCommonSelectVo();
            selectVo5.setCode(Integer.valueOf(5));
            selectVo5.setValue("\u5468\u4e94");
            ContractCommonSelectVo selectVo6 = new ContractCommonSelectVo();
            selectVo6.setCode(Integer.valueOf(6));
            selectVo6.setValue("\u5468\u516d");
            ContractCommonSelectVo selectVo7 = new ContractCommonSelectVo();
            selectVo7.setCode(Integer.valueOf(7));
            selectVo7.setValue("\u5468\u5929");
            LinkedList<ContractCommonSelectVo> reconList = new LinkedList<ContractCommonSelectVo>();
            reconList.add(selectVo1);
            reconList.add(selectVo2);
            reconList.add(selectVo3);
            reconList.add(selectVo4);
            reconList.add(selectVo5);
            reconList.add(selectVo6);
            reconList.add(selectVo7);
            LinkedList<CommonSelectVo> typeList = new LinkedList<CommonSelectVo>();
            CommonSelectVo vo1 = new CommonSelectVo();
            vo1.setCode(ContractReconPeriodTypeEnum.THIS_WEEK.getCode());
            vo1.setValue(ContractReconPeriodTypeEnum.THIS_WEEK.getValue());
            CommonSelectVo vo2 = new CommonSelectVo();
            vo2.setCode(ContractReconPeriodTypeEnum.LAST_WEEK.getCode());
            vo2.setValue(ContractReconPeriodTypeEnum.LAST_WEEK.getValue());
            typeList.add(vo1);
            typeList.add(vo2);
            dataVo.setReconList(reconList);
            dataVo.setTypeList(typeList);
            dataVo.setDateList(reconList);
        } else {
            dataVo.setNotice(ContractReconPeriodEnum.MONTH.getValue());
            LinkedList<ContractCommonSelectVo> reconList = new LinkedList<ContractCommonSelectVo>();
            for (int i = 1; i <= 30; ++i) {
                ContractCommonSelectVo selectVo = new ContractCommonSelectVo();
                selectVo.setCode(Integer.valueOf(i));
                selectVo.setValue(i + "\u53f7");
                reconList.add(selectVo);
            }
            dataVo.setReconList(reconList);
            dataVo.setDateList(reconList);
            LinkedList<CommonSelectVo> typeList = new LinkedList<CommonSelectVo>();
            CommonSelectVo vo1 = new CommonSelectVo();
            vo1.setCode(ContractReconPeriodTypeEnum.THIS_MONTH.getCode());
            vo1.setValue(ContractReconPeriodTypeEnum.THIS_MONTH.getValue());
            CommonSelectVo vo2 = new CommonSelectVo();
            vo2.setCode(ContractReconPeriodTypeEnum.LAST_MONTH.getCode());
            vo2.setValue(ContractReconPeriodTypeEnum.LAST_MONTH.getValue());
            typeList.add(vo1);
            typeList.add(vo2);
            dataVo.setTypeList(typeList);
        }
        return dataVo;
    }

    private void updateValidate(ActivityContractDto activityContractDto) {
        Validate.notNull((Object)activityContractDto, (String)"\u7f16\u8f91\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityContractDto.getId(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityContractDto.getPaymentDaysType(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u8d26\u671f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityContractDto.getBusinessUnitCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityContractDto.getBusinessFormatCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityContractDto.getContractType(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)activityContractDto.getContractType())) {
            return;
        }
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)activityContractDto.getAreaContainsList()) || !CollectionUtils.isEmpty((Collection)activityContractDto.getAreaNotContainsList()) ? 1 : 0) != 0, (String)"\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (ContractTypeEnum.RESALE_COMMERCIAL_CONTRACT.getCode().equals(activityContractDto.getContractType())) {
            Validate.notBlank((CharSequence)activityContractDto.getRetailerCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u96f6\u552e\u5546\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)activityContractDto.getRetailerName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u96f6\u552e\u5546\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)activityContractDto.getReconSponsor(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5bf9\u8d26\u53d1\u8d77\u65b9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)activityContractDto.getReconPeriod(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5bf9\u8d26\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            ContractReconPeriodEnum periodEnum = ContractReconPeriodEnum.codeToEnum((String)activityContractDto.getReconPeriod());
            Validate.notNull((Object)periodEnum, (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5bf9\u8d26\u671f\u95f4\u672a\u80fd\u8bc6\u522b\uff01", (Object[])new Object[0]);
            if (ContractReconPeriodEnum.DAY.getCode().equals(activityContractDto.getReconPeriod())) {
                activityContractDto.setReconDateList(null);
            } else {
                Validate.notEmpty((Collection)activityContractDto.getReconDateList(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5bf9\u8d26\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                for (ActivityContractReconciliationDto dto : activityContractDto.getReconDateList()) {
                    int end;
                    int start;
                    if (ContractReconPeriodEnum.WEEK.getCode().equals(activityContractDto.getReconPeriod())) {
                        Validate.isTrue((null != dto.getDayNo() && dto.getDayNo() > 0 && dto.getDayNo() <= 7 ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u751f\u6210\u5bf9\u8d26\u5355\u65f6\u95f4\u6709\u8bef\uff01\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
                        Validate.isTrue((null != dto.getStartPeriodType() && (ContractReconPeriodTypeEnum.LAST_WEEK.getCode().equals(dto.getStartPeriodType()) || ContractReconPeriodTypeEnum.THIS_WEEK.getCode().equals(dto.getStartPeriodType())) ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u5f00\u59cb\u5468\u671f\u7c7b\u578b\u6709\u8bef\uff01\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
                        Validate.isTrue((null != dto.getStartDay() && dto.getStartDay() > 0 && dto.getStartDay() <= 7 ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u5f00\u59cb\u65f6\u95f4\u6709\u8bef\uff01\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
                        Validate.isTrue((null != dto.getEndPeriodType() && (ContractReconPeriodTypeEnum.LAST_WEEK.getCode().equals(dto.getEndPeriodType()) || ContractReconPeriodTypeEnum.THIS_WEEK.getCode().equals(dto.getEndPeriodType())) ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u7ed3\u675f\u5468\u671f\u7c7b\u578b\u6709\u8bef\uff01\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
                        Validate.isTrue((null != dto.getEndDay() && dto.getEndDay() > 0 && dto.getEndDay() <= 7 ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u7ed3\u675f\u65f6\u95f4\u6709\u8bef\uff01\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
                        start = 0;
                        if (ContractReconPeriodTypeEnum.THIS_WEEK.getCode().equals(dto.getStartPeriodType())) {
                            Validate.isTrue((dto.getStartDay() < dto.getDayNo() ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u751f\u6210\u5bf9\u8d26\u5355\u65f6\u95f4", (Object[])new Object[0]);
                            start = dto.getStartDay() + 7;
                        } else {
                            start = dto.getStartDay();
                        }
                        end = 0;
                        if (ContractReconPeriodTypeEnum.THIS_WEEK.getCode().equals(dto.getEndPeriodType())) {
                            Validate.isTrue((dto.getEndDay() < dto.getDayNo() ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u751f\u6210\u5bf9\u8d26\u5355\u65f6\u95f4", (Object[])new Object[0]);
                            end = dto.getEndDay() + 7;
                        } else {
                            end = dto.getEndDay();
                        }
                        Validate.isTrue((start < end ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u5bf9\u8d26\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
                        Validate.isTrue((end - start <= 7 ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u5f00\u59cb\u65f6\u95f4\u4e0e\u5bf9\u8d26\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u95f4\u9694\u8d85\u8fc77\u5929", (Object[])new Object[0]);
                    } else {
                        Validate.isTrue((null != dto.getDayNo() && dto.getDayNo() > 0 && dto.getDayNo() <= 30 ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u751f\u6210\u5bf9\u8d26\u5355\u65f6\u95f4\u6709\u8bef\uff01\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
                        Validate.isTrue((null != dto.getStartPeriodType() && (ContractReconPeriodTypeEnum.LAST_MONTH.getCode().equals(dto.getStartPeriodType()) || ContractReconPeriodTypeEnum.THIS_MONTH.getCode().equals(dto.getStartPeriodType())) ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u5f00\u59cb\u5468\u671f\u7c7b\u578b\u6709\u8bef\uff01\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
                        Validate.isTrue((null != dto.getStartDay() && dto.getStartDay() > 0 && dto.getStartDay() <= 30 ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u5f00\u59cb\u65f6\u95f4\u6709\u8bef\uff01\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
                        Validate.isTrue((null != dto.getEndPeriodType() && (ContractReconPeriodTypeEnum.LAST_MONTH.getCode().equals(dto.getEndPeriodType()) || ContractReconPeriodTypeEnum.THIS_MONTH.getCode().equals(dto.getEndPeriodType())) ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u7ed3\u675f\u5468\u671f\u7c7b\u578b\u6709\u8bef\uff01\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
                        Validate.isTrue((null != dto.getEndDay() && dto.getEndDay() > 0 && dto.getEndDay() <= 30 ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u7ed3\u675f\u65f6\u95f4\u6709\u8bef\uff01\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
                        start = 0;
                        if (ContractReconPeriodTypeEnum.THIS_MONTH.getCode().equals(dto.getStartPeriodType())) {
                            Validate.isTrue((dto.getStartDay() < dto.getDayNo() ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u751f\u6210\u5bf9\u8d26\u5355\u65f6\u95f4", (Object[])new Object[0]);
                            start = dto.getStartDay() + 30;
                        } else {
                            start = dto.getStartDay();
                        }
                        end = 0;
                        if (ContractReconPeriodTypeEnum.THIS_MONTH.getCode().equals(dto.getEndPeriodType())) {
                            Validate.isTrue((dto.getEndDay() < dto.getDayNo() ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u751f\u6210\u5bf9\u8d26\u5355\u65f6\u95f4", (Object[])new Object[0]);
                            end = dto.getEndDay() + 30;
                        } else {
                            end = dto.getEndDay();
                        }
                        Validate.isTrue((start < end ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u5bf9\u8d26\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
                        if (ContractReconPeriodEnum.HALF_MONTH.getCode().equals(activityContractDto.getReconPeriod())) {
                            Validate.isTrue((end - start <= 15 ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u5f00\u59cb\u65f6\u95f4\u4e0e\u5bf9\u8d26\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u95f4\u9694\u8d85\u8fc715\u5929", (Object[])new Object[0]);
                        } else {
                            Validate.isTrue((end - start <= 30 ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5bf9\u8d26\u914d\u7f6e\u65f6\uff0c\u5bf9\u8d26\u5f00\u59cb\u65f6\u95f4\u4e0e\u5bf9\u8d26\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u95f4\u9694\u8d85\u8fc730\u5929", (Object[])new Object[0]);
                        }
                    }
                    dto.setContractNo(activityContractDto.getContractNo());
                    dto.setReconPeriod(activityContractDto.getReconPeriod());
                }
            }
        } else if (ContractTypeEnum.SUPPLIER_CONTRACT.getCode().equals(activityContractDto.getContractType())) {
            Validate.notBlank((CharSequence)activityContractDto.getSupplierCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)activityContractDto.getSupplierName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException("\u5408\u540c\u7c7b\u578b\u672a\u80fd\u8bc6\u522b");
        }
    }
}

