package com.biz.crm.tpm.business.activity.daily.estimated.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动监控-日预估价格管理（申请）新需求
 *
 * @author zhouyang
 * @date 2023-07-18 11:58:45
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActivityDailyEstimatedPriceApplyDto", description = "活动监控-日预估价格管理（申请）新需求")
public class ActivityDailyEstimatedPriceApplyDto extends TenantFlagOpDto {

    /**
     * 申请编码
     */
    @ApiModelProperty("申请编码")
    private String applyCode;

    @ApiModelProperty("业务模式")
    private String businessModelCode;

    @ApiModelProperty("业务模式名称")
    private String businessModelName;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式", notes = "活动形式")
    private String activityForm;

    @ApiModelProperty("业态")
    private String businessFormatCode;

    @ApiModelProperty("渠道")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("产品品项编码")
    private String productItemCode;

    @ApiModelProperty("产品品项名称")
    private String productItemName;


    /**
     * 价格申请开始日期
     */
    @ApiModelProperty("价格申请开始日期")
    private String applyBeginDate;

    /**
     * 价格申请结束日期
     */
    @ApiModelProperty("价格申请结束日期")
    private String applyEndDate;

    @ApiModelProperty("日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date applyTime;

    @ApiModelProperty("审批状态")
    private String processStatus;

    @ApiModelProperty("审批编号")
    private String processNo;

    @ApiModelProperty("活动类型")
    private String activityTypeCode;

    @ApiModelProperty("活动类型")
    private String activityType;

    @ApiModelProperty("标准零售价")
    private BigDecimal standardRetailPrice = BigDecimal.ZERO;

    @ApiModelProperty("公允价")
    private BigDecimal fairPrice;

    @ApiModelProperty("底线价")
    private BigDecimal bottomPrice;

    @ApiModelProperty("促销选品价")
    private BigDecimal promotionSelectionPrice;

    @ApiModelProperty("月促销规划均价")
    private BigDecimal monthPromotionAveragePrice;

    @ApiModelProperty("当日执行价")
    private BigDecimal dailyExecutionPrice;

    @ApiModelProperty("MTD价")
    private BigDecimal mtdPrice;

    @ApiModelProperty("价格力度")
    private BigDecimal priceDynamics;

    @ApiModelProperty("执行价VSMTD")
    private BigDecimal executionVsMtdPrice;

    @ApiModelProperty("执行价VS月促销均价")
    private BigDecimal executionVsAveragePrice;

    @ApiModelProperty("执行价VS促销选品价")
    private BigDecimal executionVsSelectionPrice;

    @ApiModelProperty("MTDVS月促销规划均价")
    private BigDecimal mtdVsAveragePrice;

    @ApiModelProperty("执行价VS公允价")
    private BigDecimal executionVsFairPrice;

    @ApiModelProperty("执行价VS底线")
    private BigDecimal executionVsBottomPrice;

    /**
     * 定价记录号
     */
    @ApiModelProperty("定价记录号")
    private String pricingCode;

    /**
     * 错误信息
     */
    @JsonIgnore
    @ApiModelProperty("错误信息")
    private String errorMsg;

}