package com.biz.crm.tpm.business.activity.daily.estimated.sdk.pojo;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 活动监控-日预估价格管理（申请）-申请头
 *
 * @author zhouyang
 * @date 2023-07-18 11:58:45
 */
@Data
public class ActivityDailyEstimatedPriceApplyHeadBase extends TenantFlagOpEntity {

    @ApiModelProperty(name = "id", value = "主键ID")
    private String id;
    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;
    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;
    @ApiModelProperty(name = "delFlag", value = "删除状态，003已删除，009未删除")
    private String delFlag;
    @ApiModelProperty(name = "enableStatus", value = "启禁用状态，003禁用，009启用")
    private String enableStatus;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;

    
    /**
     * 申请编码
     */
    @ApiModelProperty("申请编码")
    private String applyCode;

    /**
     * 价格申请名称
     */
    @ApiModelProperty("价格申请名称")
    private String applyName;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 分销渠道编码
     */
    @ApiModelProperty("分销渠道编码")
    private String distributionChannelCode;

    /**
     * 分销渠道名称
     */
    @ApiModelProperty("分销渠道名称")
    private String distributionChannelName;


    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionErpCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    private String salesInstitutionName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户ERP编码")
    private String customerErpCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("业务模式")
    private String businessModelCode;

    @ApiModelProperty("业务模式名称")
    private String businessModelName;

    /**
     * （Hr）部门编码
     */
    @ApiModelProperty("（Hr）部门编码")
    private String orgCode;

    /**
     * （Hr）部门名称
     */
    @ApiModelProperty("（Hr）部门名称")
    private String orgName;

    /**
     * 价格申请开始日期
     */
    @ApiModelProperty("价格申请开始日期")
    private String applyBeginDate;

    /**
     * 价格申请结束日期
     */
    @ApiModelProperty("价格申请结束日期")
    private String applyEndDate;

    /**
     * 流程编号
     */
    @ApiModelProperty("流程编号")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String processStatus;

    /**
     * 流程审批通过时间
     */
    @ApiModelProperty("流程审批通过时间")
    private String processPassTime;
    
    /**
     * 创建人所属组织编码
     */
    @ApiModelProperty("创建人所属组织编码")
    private String createOrgCode;

    /**
     * 创建人所属组织名称
     */
    @ApiModelProperty("创建人所属组织名称")
    private String createOrgName;

    /**
     * 是否已校验
     */
    @ApiModelProperty(name = "是否已校验", notes = "")
    private String isValidate;

}