package com.biz.crm.tpm.business.activity.design.monitor.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.design.monitor.sdk.service.TpmActivityDesignMonitorService;
import com.biz.crm.tpm.business.activity.design.monitor.sdk.dto.TpmActivityDesignMonitorDto;
import com.biz.crm.tpm.business.activity.design.monitor.sdk.vo.TpmActivityDesignMonitorVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

/**
 * TPM-活动规划监控表(TpmActivityDesignMonitor)表相关的http接口
 *
 * @author duyiran
 * @since 2022-12-30 09:44:51
 */
@RestController
@RequestMapping("/v1/tpmActivityDesignMonitor")
@Slf4j
@Api(tags = "TPM-活动规划监控表")
public class TpmActivityDesignMonitorController {

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private TpmActivityDesignMonitorService tpmActivityDesignMonitorService;

    /**
     * 分页查询所有数据
     *
     * @param pageable                 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<TpmActivityDesignMonitorVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                     @ApiParam(name = "dto", value = "TPM-活动规划监控表") TpmActivityDesignMonitorDto dto) {
        try {
            Page<TpmActivityDesignMonitorVo> page = this.tpmActivityDesignMonitorService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
