package com.biz.crm.tpm.business.activity.design.monitor.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 活动规划监控表 实体
 *
 * @author duyiran
 * @date 2022-11-07 17:42
 */
@Data
@TableName("tpm_activity_design_monitor")
@Entity(name = "tpm_activity_design_monitor")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmActivityDesignMonitor", description = "TPM-活动规划监控表")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_design_monitor", comment = "TPM-活动规划监控表")
@Table(name = "tpm_activity_design_monitor", indexes = {@Index(name = "tpm_activity_design_monitor_index1", columnList = "tenant_code, detail_plan_item_code", unique = true)})
public class TpmActivityDesignMonitor extends TenantFlagOpEntity {

    /**
     * 活动细案编码
     */
    @ApiModelProperty(name = "活动细案编码", notes = "活动细案编码")
    @Column(name = "detail_plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    private String detailPlanCode;

    /**
     * 活动细案名称
     */
    @ApiModelProperty(name = "活动细案名称", notes = "活动细案名称")
    @Column(name = "detail_plan_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动细案名称'")
    private String detailPlanName;

    /**
     * 活动细案明细编码
     */
    @ApiModelProperty(name = "活动细案明细编码", notes = "活动细案明细编码")
    @Column(name = "detail_plan_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动细案明细编码'")
    private String detailPlanItemCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业态[数据字典:mdm_business_format]'")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业务单元[数据字典:mdm_business_unit]'")
    private String businessUnitCode;

    /**
     * 促销对象
     */
    @ApiModelProperty(name = "促销对象", notes = "促销对象")
    @Column(name = "promotion_object", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '促销对象'")
    private String promotionObject;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Column(name = "customer_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(name = "门店编码", notes = "门店编码")
    @Column(name = "terminal_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "门店名称", notes = "门店名称")
    @Column(name = "terminal_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '门店名称'")
    private String terminalName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    @Column(name = "product_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    /**
     * 活动类型编码
     */
    @ApiModelProperty(name = "活动类型编码", notes = "活动类型编码")
    @Column(name = "activity_type_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动类型编码'")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    @Column(name = "activity_type_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动类型名称'")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 单位编码
     */
    @ApiModelProperty(name = "单位编码", notes = "单位编码")
    @Column(name = "product_unit", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '单位编码'")
    private String productUnit;

    /**
     * 促销力度
     */
    @ApiModelProperty(name = "促销力度", notes = "促销力度")
    @Column(name = "promotion_intensity", length = 12, columnDefinition = "DECIMAL(12,6) COMMENT '促销力度'")
    private BigDecimal promotionIntensity;

    /**
     * 促销价格
     */
    @ApiModelProperty(name = "促销价格", notes = "促销价格")
    @Column(name = "promotion_amount", length = 16, columnDefinition = "DECIMAL(16,6) COMMENT '促销价格'")
    private BigDecimal promotionAmount;

    /**
     * 实际规划价
     */
    @ApiModelProperty(name = "实际规划价", notes = "实际规划价")
    @Column(name = "actual_plan_price", length = 12, columnDefinition = "DECIMAL(12,6) COMMENT '实际规划价'")
    private BigDecimal actualPlanPrice;

    /**
     * 偏差值
     */
    @ApiModelProperty(name = "偏差值", notes = "偏差值")
    @Column(name = "difference_value", length = 16, columnDefinition = "DECIMAL(16,6) COMMENT '偏差值'")
    private BigDecimal differenceValue;

}
