package com.biz.crm.tpm.business.activity.design.monitor.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.design.monitor.local.entity.TpmActivityDesignMonitor;
import com.biz.crm.tpm.business.activity.design.monitor.local.mapper.TpmActivityDesignMonitorMapper;
import com.biz.crm.tpm.business.activity.design.monitor.sdk.dto.TpmActivityDesignMonitorDto;
import com.biz.crm.tpm.business.activity.design.monitor.sdk.vo.TpmActivityDesignMonitorVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;


/**
 * TPM-活动规划监控表(TpmActivityDesignMonitor)表数据库访问层
 *
 * @author duyiran
 * @since 2022-12-30 09:44:54
 */
@Component
public class TpmActivityDesignMonitorRepository extends ServiceImpl<TpmActivityDesignMonitorMapper, TpmActivityDesignMonitor> {

    @Autowired(required = false)
    private TpmActivityDesignMonitorMapper tpmActivityDesignMonitorMapper;

    /**
     * 分页查询数据
     *
     * @param pageable                 分页对象
     * @param dto 实体对象
     * @return
     */
    public Page<TpmActivityDesignMonitorVo> findByConditions(Pageable pageable, TpmActivityDesignMonitorDto dto) {
        Page<TpmActivityDesignMonitorVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.tpmActivityDesignMonitorMapper.findByConditions(page, dto);
    }
}

