package com.biz.crm.tpm.business.activity.design.monitor.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.design.monitor.local.entity.TpmActivityDesignMonitor;
import com.biz.crm.tpm.business.activity.design.monitor.local.repository.TpmActivityDesignMonitorRepository;
import com.biz.crm.tpm.business.activity.design.monitor.sdk.dto.TpmActivityDesignMonitorDto;
import com.biz.crm.tpm.business.activity.design.monitor.sdk.service.TpmActivityDesignMonitorService;
import com.biz.crm.tpm.business.activity.design.monitor.sdk.vo.TpmActivityDesignMonitorVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;

/**
 * TPM-活动规划监控表(TpmActivityDesignMonitor)表服务实现类
 *
 * @author duyiran
 * @since 2022-12-30 09:44:52
 */
@Service("tpmActivityDesignMonitorService")
public class TpmActivityDesignMonitorServiceImpl implements TpmActivityDesignMonitorService {

    @Autowired(required = false)
    private TpmActivityDesignMonitorRepository tpmActivityDesignMonitorRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      实体对象
     * @return
     */
    @Override
    public Page<TpmActivityDesignMonitorVo> findByConditions(Pageable pageable, TpmActivityDesignMonitorDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new TpmActivityDesignMonitorDto();
        }
        return this.tpmActivityDesignMonitorRepository.findByConditions(pageable, dto);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public TpmActivityDesignMonitorVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        TpmActivityDesignMonitor entity = this.tpmActivityDesignMonitorRepository.getById(id);
        Validate.notNull(entity, "数据不存在或已被删除！");
        return this.nebulaToolkitService.copyObjectByWhiteList(entity, TpmActivityDesignMonitorVo.class, LinkedHashSet.class, ArrayList.class);
    }

}

