package com.biz.crm.tpm.business.activity.design.monitor.sdk.event.log;

import com.biz.crm.tpm.business.activity.design.monitor.sdk.dto.log.TpmActivityDesignMonitorLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author duyiran
 * @date 2022年10月26日 14:15
 */
public interface TpmActivityDesignMonitorLogEventListener extends NebulaEvent {
    /**
     * 创建预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onCreate(TpmActivityDesignMonitorLogEventDto dto);

    /**
     * 删除预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onDelete(TpmActivityDesignMonitorLogEventDto dto);

    /**
     * 修改预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onUpdate(TpmActivityDesignMonitorLogEventDto dto);

    /**
     * 启用预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onEnable(TpmActivityDesignMonitorLogEventDto dto);

    /**
     * 禁用预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onDisable(TpmActivityDesignMonitorLogEventDto dto);
}
