package com.biz.crm.tpm.business.activity.design.monitor.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * vo
 *
 * @author duyiran
 * @create 2022-11-07 19:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmActivityDesignMonitorVo", description = "TPM-活动规划监控表")
public class TpmActivityDesignMonitorVo extends TenantFlagOpVo {

    /**
     * 活动细案编码
     */
    @ApiModelProperty(name = "活动细案编码", notes = "活动细案编码")
    private String detailPlanCode;

    /**
     * 活动细案名称
     */
    @ApiModelProperty(name = "活动细案名称", notes = "活动细案名称")
    private String detailPlanName;

    /**
     * 活动细案明细编码
     */
    @ApiModelProperty(name = "活动细案明细编码", notes = "活动细案明细编码")
    private String detailPlanItemCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 促销对象
     */
    @ApiModelProperty(name = "促销对象", notes = "促销对象")
    private String promotionObject;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(name = "门店编码", notes = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "门店名称", notes = "门店名称")
    private String terminalName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    private String productName;

    /**
     * 活动类型编码
     */
    @ApiModelProperty(name = "活动类型编码", notes = "活动类型编码")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    /**
     * 单位编码
     */
    @ApiModelProperty(name = "单位编码", notes = "单位编码")
    private String productUnit;

    /**
     * 促销力度
     */
    @ApiModelProperty(name = "促销力度", notes = "促销力度")
    private BigDecimal promotionIntensity;

    /**
     * 促销价格
     */
    @ApiModelProperty(name = "促销价格", notes = "促销价格")
    private BigDecimal promotionAmount;

    /**
     * 实际规划价
     */
    @ApiModelProperty(name = "实际规划价", notes = "实际规划价")
    private BigDecimal actualPlanPrice;

    /**
     * 偏差值
     */
    @ApiModelProperty(name = "偏差值", notes = "偏差值")
    private BigDecimal differenceValue;

}
