package com.biz.crm.tpm.business.activity.detail.plan.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.detail.plan.feign.impl.ActivityDetailPlanFeignImpl;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.*;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName ActivityDetailPlanFeign
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/16
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = ActivityDetailPlanFeignImpl.class)
public interface ActivityDetailPlanFeign {

    @GetMapping("/v1/activityDetailPlan/findById")
    Result<ActivityDetailPlanVo> findById(@ApiParam(value = "id")@RequestParam String id);

    @PostMapping("/v1/activityDetailPlan/saveActivityPlanNoCache")
    Result<ActivityDetailPlanOutDto> createOrUpdate(@RequestBody ActivityDetailPlanDto outDto);

    @PostMapping(value = "/v1/activityDetailPlan/deletePos")
    Result<?> delete(@ApiParam(value = "活动方案id集合")@RequestParam List<String> ids);

    @PostMapping("/v1/activityDetailPlan/atomicCreateForOut")
    Result<ActivityDetailPlanOutDto> atomicCreateForOut(@RequestBody ActivityDetailPlanDto dto);

    @GetMapping("/v1/activityDetailPlan/findPageForOut")
    Result<Page<ActivityDetailPlanVo>> findPageForOut(@ApiParam(name = "pageable") Pageable pageable,
                                                      @ApiParam(name = "dto") @SpringQueryMap ActivityDetailPlanDto dto);
    @GetMapping("/v1/activityDetailPlan/activityDetailPlanItem/findPage")
    Result<Page<ActivityDetailPlanItemVo>> findPlanItemByConditions(
        @ApiParam(name = "pageable") Pageable pageable,
        @ApiParam(name = "dto") @SpringQueryMap ActivityDetailPlanItemDto activityDetailPlanItemDto);


}
