package com.biz.crm.tpm.business.activity.detail.plan.feign;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.detail.plan.feign.impl.ForeignActivityDetailPlanApiFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 外部系统调用处理活动细案接口
 * @author wanghaojia
 * @date 2023/11/24 12:16
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = ForeignActivityDetailPlanApiFeignImpl.class)
public interface ForeignActivityDetailPlanApiFeign {

    /**
     * 活动细案创建接口
     * @param object 参数
     */
    @PostMapping(value = "/v1/foreign/api/activityDetailPlan/create")
    Result<Page<Object>> create(JSONObject object);

}
