package com.biz.crm.tpm.business.activity.detail.plan.feign;

import com.biz.crm.tpm.business.activity.detail.plan.feign.impl.SfaPushActivityDetailPlanFeignImpl;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.sfa.SfaFeeDetailDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.sfa.display.SfaActivityDetailPlanCreateResult;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.sfa.display.SfaActivityDetailPlanDisplayCreateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.display.SfaActivityPlanDisplayCreateDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.biz.crm.business.common.sdk.model.Result;
import java.util.List;

/**
 * SFA推送费用明细feign
 * @author wanghaojia
 * @date 2023/1/5 16:39
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = SfaPushActivityDetailPlanFeignImpl.class)
public interface SfaPushActivityDetailPlanFeign {

    @PostMapping(value = "/v1/activityDetailPlan/pushSfaFeeDetailList")
    Result pushSfaFeeDetailList(@RequestBody List<SfaFeeDetailDto> dtoList);

    @PostMapping(value = "/v1/activityDetailPlan/sfaActivityDetailPlanCreateDisplay")
    Result<List<SfaActivityDetailPlanCreateResult>> sfaActivityDetailPlanCreateDisplay(@RequestBody List<SfaActivityDetailPlanDisplayCreateDto> list);

}
