package com.biz.crm.tpm.business.activity.detail.plan.feign.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.detail.plan.feign.ActivityDetailPlanFeign;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName ActivityDetailPlanFeignImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/16
 */
@Component
@Slf4j
public class ActivityDetailPlanFeignImpl implements FallbackFactory<ActivityDetailPlanFeign> {
    @Override
    public ActivityDetailPlanFeign create(Throwable cause) {
        log.error("活动细案进入熔断");
        return new ActivityDetailPlanFeign(){

            @Override
            public Result<ActivityDetailPlanVo> findById(String id) {
                throw new UnsupportedOperationException("查询活动细案详情进入熔断");
            }

            @Override
            public Result<ActivityDetailPlanOutDto> createOrUpdate(ActivityDetailPlanDto outDto) {
                if (StringUtils.isEmpty(outDto.getId())) {
                    throw new UnsupportedOperationException("创建活动细案进入熔断");
                } else {
                    throw new UnsupportedOperationException("更改活动细案进入熔断");
                }
            }

            @Override
            public Result<?> delete(List<String> ids) {
                throw new UnsupportedOperationException("关闭活动细案进入熔断");
            }

            @Override
            public Result<ActivityDetailPlanOutDto> atomicCreateForOut(ActivityDetailPlanDto dto) {
                throw new UnsupportedOperationException("创建活动细案进入熔断");
            }

            @Override
            public Result<Page<ActivityDetailPlanVo>> findPageForOut(Pageable pageable, ActivityDetailPlanDto dto) {
                throw new UnsupportedOperationException("查询活动细案列表进入熔断");
            }
            @Override
            public Result<Page<ActivityDetailPlanItemVo>> findPlanItemByConditions(
                 Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto){
                throw new UnsupportedOperationException("查询活动细案列表进入熔断");
            }
        };
    }
}
